/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CasterTome
extends ModItem
implements ICasterTool {
    public CasterTome(Item.Properties properties) {
        super(properties);
    }

    public CasterTome(Item.Properties properties, String registryName) {
        super(properties, registryName);
    }

    public CasterTome(String registryName) {
        super(registryName);
    }

    @Override
    public boolean onScribe(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        return player.func_184812_l_() && ICasterTool.super.onScribe(world, pos, player, handIn, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell spell = caster.getSpell();
        spell.setCost(Math.min(spell.getCastingCost() / 2, ManaUtil.getMaxMana(playerIn)));
        return caster.castSpell(worldIn, playerIn, handIn, new TranslationTextComponent(""), spell);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell spell = caster.getSpell();
        tooltip2.add((ITextComponent)new StringTextComponent(spell.getDisplayString()));
        if (!caster.getFlavorText().isEmpty()) {
            tooltip2.add((ITextComponent)new StringTextComponent(caster.getFlavorText()).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.BLUE)));
        }
        tooltip2.add((ITextComponent)new TranslationTextComponent("tooltip.ars_nouveau.caster_tome"));
        super.func_77624_a(stack, worldIn, tooltip2, flagIn);
    }
}

