/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarDrygmy;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarSylph;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class FamiliarEvents {
    public static List<FamiliarEntity> getFamiliars(Predicate<FamiliarEntity> predicate) {
        ArrayList<FamiliarEntity> stale = new ArrayList<FamiliarEntity>();
        ArrayList<FamiliarEntity> matching = new ArrayList<FamiliarEntity>();
        for (FamiliarEntity familiarEntity : FamiliarEntity.FAMILIAR_SET) {
            if (familiarEntity.field_70128_L || familiarEntity.terminatedFamiliar || familiarEntity.getOwner() == null) {
                stale.add(familiarEntity);
                continue;
            }
            if (!predicate.test(familiarEntity)) continue;
            matching.add(familiarEntity);
        }
        FamiliarEntity.FAMILIAR_SET.removeAll(stale);
        return matching;
    }

    @SubscribeEvent
    public static void summonEvent(FamiliarSummonEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(f -> true)) {
            if (entity.getOwner() == null || !entity.getOwner().equals((Object)event.owner)) continue;
            entity.onFamiliarSpawned(event);
        }
    }

    @SubscribeEvent
    public static void castEvent(SpellCastEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(f -> f instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onCast(event);
        }
    }

    @SubscribeEvent
    public static void maxManaCalc(MaxManaCalcEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> true)) {
            if (!entity.func_70089_S()) {
                return;
            }
            if (entity.getOwner() == null || !entity.getOwner().equals((Object)event.getEntity())) continue;
            event.setMax((int)((double)event.getMax() - (double)event.getMax() * entity.getManaReserveModifier()));
        }
    }

    @SubscribeEvent
    public static void spellResolveEvent(SpellModifierEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onModifier(event);
        }
    }

    @SubscribeEvent
    public static void modifierEvent(SpellModifierEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onModifier(event);
        }
    }

    @SubscribeEvent
    public static void fortuneEvent(LootingLevelEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof FamiliarDrygmy)) {
            if (!(entity instanceof FamiliarDrygmy)) continue;
            ((FamiliarDrygmy)entity).onLootingEvent(event);
        }
    }

    @SubscribeEvent
    public static void eatEvent(LivingEntityUseItemEvent.Finish event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof FamiliarSylph)) {
            if (!(entity instanceof FamiliarSylph)) continue;
            ((FamiliarSylph)entity).eatEvent(event);
        }
    }

    @SubscribeEvent
    public static void potionEvent(PotionEvent.PotionAddedEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof FamiliarWixie)) {
            if (!(entity instanceof FamiliarWixie)) continue;
            ((FamiliarWixie)entity).potionEvent(event);
        }
    }
}

