/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class FamiliarSylph
extends FlyingFamiliarEntity
implements ISpellCastListener {
    public FamiliarSylph(EntityType<? extends CreatureEntity> ent, World world) {
        super(ent, world);
    }

    @Override
    public void onCast(SpellCastEvent event) {
        if (!this.func_70089_S()) {
            return;
        }
        if (this.getOwner() != null && this.getOwner().equals((Object)event.getEntity())) {
            int cost = event.spell.getCastingCost();
            for (AbstractSpellPart part : event.spell.recipe) {
                if (!part.getSchools().contains(SpellSchools.ELEMENTAL_EARTH)) continue;
                cost = (int)((double)cost - (double)part.getConfigCost() * 0.5);
            }
            event.spell.setCost(cost);
        }
    }

    public void eatEvent(LivingEntityUseItemEvent.Finish event) {
        if (!this.func_70089_S()) {
            return;
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K && this.getOwner() != null && this.getOwner().equals((Object)event.getEntity()) && event.getItem().func_77973_b().func_219967_s() != null && event.getItem().func_77973_b().func_219971_r()) {
            Food food = event.getItem().func_77973_b().func_219967_s();
            float saturationModifier = food.func_221469_b();
            int nutrition = food.func_221466_a();
            float satAmount = (float)nutrition * saturationModifier * 2.0f;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                FoodStats stats = ((PlayerEntity)event.getEntityLiving()).func_71024_bL();
                stats.field_75125_b += satAmount * 0.4f;
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public PlayState walkPredicate(AnimationEvent event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_FAMILIAR_SYLPH;
    }
}

