/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.BookwyrmLectern;
import com.hollingsworth.arsnouveau.common.block.ManaBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class BookwyrmLecternTile
extends SummoningTile
implements IWandable {
    int tier = 1;
    public boolean isOff;
    int taskIndex;

    public BookwyrmLecternTile() {
        super(BlockRegistry.BOOKWYRM_LECTERN_TILE);
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.field_145850_b.field_72995_K) {
            this.converted = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityBookwyrm bookwyrm = new EntityBookwyrm(this.field_145850_b, this.field_174879_c);
            bookwyrm.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.field_145850_b.func_217376_c((Entity)bookwyrm);
            ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, this.field_174879_c.func_177984_a());
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.field_145850_b.field_72995_K) {
            Random r = this.field_145850_b.field_73012_v;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c.func_177982_a(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.field_174879_c, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.field_145850_b.func_217376_c((Entity)proj1);
        }
    }

    public void changeTier(PlayerEntity entity) {
        if (this.tier == 1 || this.tier == 0) {
            this.tier = 2;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.set", new Object[]{"5 x 5"}), Util.field_240973_b_);
        } else if (this.tier == 2) {
            this.tier = 3;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.set", new Object[]{"9 x 9"}), Util.field_240973_b_);
        } else if (this.tier == 3) {
            this.tier = 4;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.set", new Object[]{"13 x 13"}), Util.field_240973_b_);
        } else if (this.tier == 4) {
            this.tier = 5;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.set", new Object[]{"17 x 17"}), Util.field_240973_b_);
        } else if (this.tier == 5) {
            this.tier = 1;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.adjacent"), Util.field_240973_b_);
        }
    }

    public boolean enoughMana(@Nullable Spell spell) {
        if (spell == null) {
            return false;
        }
        return ManaUtil.hasManaNearby(this.field_174879_c, this.field_145850_b, 7, spell.getCastingCost() / 4);
    }

    public boolean removeManaAround(@Nullable Spell spell) {
        if (spell == null) {
            return false;
        }
        return ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 7, spell.getCastingCost() / 4) != null;
    }

    @Nullable
    public BlockPos getNextTaskLoc(@Nullable Spell spell, EntityBookwyrm caster) {
        if (this.isOff || spell == null) {
            return null;
        }
        List<BlockPos> posList = this.getTargets();
        if (posList == null || posList.isEmpty()) {
            return null;
        }
        BlockPos taskPos = null;
        boolean wouldSucceed = false;
        for (int i = 0; i < posList.size(); ++i) {
            SpellResolver resolver;
            Block block;
            if (this.taskIndex >= posList.size()) {
                this.taskIndex = 0;
            }
            taskPos = posList.get(this.taskIndex);
            ++this.taskIndex;
            if (this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_185904_a() != Material.field_151579_a && !BlockUtil.isTreeBlock(this.field_145850_b.func_180495_p(taskPos).func_177230_c())) {
                for (int j = 1; j < 4; ++j) {
                    if (this.field_145850_b.func_180495_p(taskPos.func_177981_b(i)).func_185904_a() == Material.field_151579_a && !BlockUtil.isTreeBlock(this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_177230_c())) continue;
                    taskPos = taskPos.func_177981_b(i);
                    break;
                }
            }
            if ((block = this.field_145850_b.func_180495_p(taskPos).func_177230_c()) instanceof BookwyrmLectern || block instanceof ContainerBlock || block instanceof ManaBlock || block instanceof IInventory || ((Boolean)caster.func_184212_Q().func_187225_a(EntityBookwyrm.STRICT_MODE)).booleanValue() && !(resolver = new SpellResolver(new SpellContext(spell, (LivingEntity)caster))).wouldCastOnBlockSuccessfully(new BlockRayTraceResult(new Vector3d((double)taskPos.func_177958_n(), (double)taskPos.func_177956_o(), (double)taskPos.func_177952_p()), Direction.UP, taskPos, false), (LivingEntity)caster)) continue;
            wouldSucceed = true;
            break;
        }
        return wouldSucceed ? taskPos : null;
    }

    public List<BlockPos> getTargets() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.tier == 1) {
            positions.add(this.func_174877_v().func_177978_c().func_177977_b());
            positions.add(this.func_174877_v().func_177968_d().func_177977_b());
            positions.add(this.func_174877_v().func_177974_f().func_177977_b());
            positions.add(this.func_174877_v().func_177976_e().func_177977_b());
        }
        if (this.tier == 2) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(2).func_177965_g(2).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(2).func_177985_f(2).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        if (this.tier == 3) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(4).func_177965_g(4).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(4).func_177985_f(4).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        if (this.tier == 4) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(6).func_177965_g(6).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(6).func_177985_f(6).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        if (this.tier == 5) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(8).func_177965_g(8).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(8).func_177985_f(8).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        return positions;
    }

    public ItemStack insertItem(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, stack);
    }

    public ItemStack getItem(Item item) {
        return BlockUtil.getItemAdjacent(this.field_145850_b, this.field_174879_c, stack -> stack.func_77973_b() == item);
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.changeTier(playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.taskIndex = tag.func_74762_e("task_index");
        this.tier = tag.func_74762_e("tier");
        this.isOff = tag.func_74767_n("is_off");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("task_index", this.taskIndex);
        tag.func_74768_a("tier", this.tier);
        tag.func_74757_a("is_off", this.isOff);
        return super.func_189515_b(tag);
    }
}

