/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ArcaneRelayTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;

public class ArcaneRelaySplitterTile
extends ArcaneRelayTile {
    ArrayList<BlockPos> toList = new ArrayList();
    ArrayList<BlockPos> fromList = new ArrayList();

    public ArcaneRelaySplitterTile() {
        super(BlockRegistry.ARCANE_RELAY_SPLITTER_TILE);
    }

    public ArcaneRelaySplitterTile(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public boolean setTakeFrom(BlockPos pos) {
        return this.closeEnough(pos) && this.fromList.add(pos) && this.update();
    }

    @Override
    public boolean setSendTo(BlockPos pos) {
        return this.closeEnough(pos) && this.toList.add(pos) && this.update();
    }

    @Override
    public void clearPos() {
        this.toList.clear();
        this.fromList.clear();
        this.update();
    }

    public void processFromList() {
        if (this.fromList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getTransferRate() / this.fromList.size();
        for (BlockPos fromPos : this.fromList) {
            if (!(this.field_145850_b.func_175625_s(fromPos) instanceof AbstractManaTile)) {
                stale.add(fromPos);
                continue;
            }
            AbstractManaTile fromTile = (AbstractManaTile)this.field_145850_b.func_175625_s(fromPos);
            if (this.transferMana(fromTile, this, ratePer) <= 0) continue;
            this.createParticles(fromPos, this.field_174879_c);
        }
        for (BlockPos s : stale) {
            this.fromList.remove(s);
        }
    }

    public void createParticles(BlockPos from, BlockPos to) {
        ParticleUtil.spawnFollowProjectile(this.field_145850_b, from, to);
    }

    public void processToList() {
        if (this.toList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getTransferRate() / this.toList.size();
        for (BlockPos toPos : this.toList) {
            if (!(this.field_145850_b.func_175625_s(toPos) instanceof AbstractManaTile)) {
                stale.add(toPos);
                continue;
            }
            AbstractManaTile toTile = (AbstractManaTile)this.field_145850_b.func_175625_s(toPos);
            int transfer = this.transferMana(this, toTile, ratePer);
            if (transfer <= 0) continue;
            this.createParticles(this.field_174879_c, toPos);
        }
        for (BlockPos s : stale) {
            this.toList.remove(s);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L != 0L || this.toList.isEmpty() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.processFromList();
        this.processToList();
        this.update();
    }

    @Override
    public int getTransferRate() {
        return 2500;
    }

    @Override
    public int getMaxMana() {
        return 2500;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        BlockPos pos;
        super.func_230337_a_(state, tag);
        this.fromList = new ArrayList();
        this.toList = new ArrayList();
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.fromList.contains(pos)) {
                this.fromList.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.toList.contains(pos)) {
                this.toList.add(NBTUtil.getBlockPos(tag, "to_" + counter));
            }
            ++counter;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        int counter = 0;
        for (BlockPos p : this.fromList) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, p);
            ++counter;
        }
        counter = 0;
        for (BlockPos p : this.toList) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, p);
            ++counter;
        }
        return super.func_189515_b(tag);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.toList == null || this.toList.isEmpty()) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_to").getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_to", new Object[]{this.toList.size()}).getString());
        }
        if (this.fromList == null || this.fromList.isEmpty()) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_from").getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_from", new Object[]{this.fromList.size()}).getString());
        }
        return list;
    }
}

