/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ManaJar;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PotionJar
extends ModBlock {
    public PotionJar(AbstractBlock.Properties properties, String registry) {
        super(properties, registry);
    }

    public PotionJar(String registry) {
        super(registry);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        PotionJarTile tile = (PotionJarTile)worldIn.func_175625_s(pos);
        if (tile == null || tile.getCurrentFill() <= 0) {
            return 0;
        }
        int step = (tile.getMaxFill() - 1) / 14;
        return (tile.getCurrentFill() - 1) / step + 1;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PotionJarTile tile = (PotionJarTile)worldIn.func_175625_s(pos);
        if (tile == null) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(handIn);
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        if (stack.func_77973_b() == Items.field_151068_bn && potion != Potions.field_185229_a) {
            if (tile.getAmount() == 0) {
                tile.setPotion(stack);
                tile.addAmount(100);
                if (!player.func_184812_l_()) {
                    player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo));
                    stack.func_190918_g(1);
                }
            } else if (tile.isMixEqual(stack) && tile.getCurrentFill() < tile.getMaxFill()) {
                tile.addAmount(100);
                if (!player.func_184812_l_()) {
                    player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo));
                    stack.func_190918_g(1);
                }
            }
            worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
        }
        if (stack.func_77973_b() == Items.field_151069_bo && tile.getCurrentFill() >= 100) {
            ItemStack potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)tile.getPotion());
            PotionUtils.func_185184_a((ItemStack)potionStack, tile.getCustomEffects());
            player.func_191521_c(potionStack);
            player.func_184586_b(handIn).func_190918_g(1);
            tile.addAmount(-100);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ManaJar.fill});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PotionJarTile();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77978_p() == null) {
            return;
        }
        int mana = stack.func_77978_p().func_74775_l("BlockEntityTag").func_74762_e("amount");
        tooltip.add((ITextComponent)new StringTextComponent(mana * 100 / 10000 + "% full"));
        ItemStack stack1 = new ItemStack((IItemProvider)Items.field_151068_bn);
        stack1.func_77982_d(stack.func_77978_p().func_74775_l("BlockEntityTag"));
        PotionUtils.func_185182_a((ItemStack)stack1, tooltip, (float)1.0f);
    }
}

