/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpellStats {
    private double amplification;
    private double damageModifier;
    private double durationMultiplier;
    private List<AbstractAugment> augments = new ArrayList<AbstractAugment>();
    private List<ItemStack> modifierItems = new ArrayList<ItemStack>();

    private SpellStats() {
    }

    public int getDurationInTicks() {
        return (int)(20.0 * this.durationMultiplier);
    }

    public int getBuffCount(AbstractAugment abstractAugment) {
        return (int)this.augments.stream().filter(abstractAugment::equals).count();
    }

    public boolean hasBuff(AbstractAugment abstractAugment) {
        return this.getBuffCount(abstractAugment) > 0;
    }

    public List<ITextComponent> addTooltip(List<ITextComponent> components) {
        if (this.damageModifier != 0.0) {
            components.add((ITextComponent)new TranslationTextComponent("tooltip.ars_nouveau.spell_damage", new Object[]{this.damageModifier}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)));
        }
        if (this.durationMultiplier != 0.0) {
            components.add((ITextComponent)new TranslationTextComponent("tooltip.ars_nouveau.duration_modifier", new Object[]{this.durationMultiplier}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)));
        }
        if (this.amplification != 0.0) {
            components.add((ITextComponent)new TranslationTextComponent("tooltip.ars_nouveau.amp_modifier", new Object[]{this.amplification}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)));
        }
        return components;
    }

    public double getAmpMultiplier() {
        return this.amplification;
    }

    public void setAmpMultiplier(double amplification) {
        this.amplification = amplification;
    }

    public double getDamageModifier() {
        return this.damageModifier;
    }

    public void setDamageModifier(double damageModifier) {
        this.damageModifier = damageModifier;
    }

    public double getDurationMultiplier() {
        return this.durationMultiplier;
    }

    public void setDurationMultiplier(double durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
    }

    public List<AbstractAugment> getAugments() {
        return this.augments;
    }

    public void setAugments(List<AbstractAugment> augments) {
        this.augments = augments;
    }

    public List<ItemStack> getModifierItems() {
        return this.modifierItems;
    }

    public void setModifierItems(List<ItemStack> modifierItems) {
        this.modifierItems = modifierItems;
    }

    public static class Builder {
        private SpellStats spellStats = new SpellStats();

        public SpellStats build(AbstractSpellPart spellPart, RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellContext spellContext) {
            for (AbstractAugment abstractAugment : this.spellStats.augments) {
                abstractAugment.applyModifiers(this, spellPart);
            }
            for (ItemStack stack : this.spellStats.modifierItems) {
                if (!(stack.func_77973_b() instanceof ISpellModifierItem)) continue;
                for (int i = 0; i < stack.func_190916_E(); ++i) {
                    ((ISpellModifierItem)stack.func_77973_b()).applyItemModifiers(stack, this, spellPart, rayTraceResult, world, shooter, spellContext);
                }
            }
            SpellModifierEvent modifierEvent = new SpellModifierEvent(shooter, this, spellPart, rayTraceResult, world, spellContext);
            MinecraftForge.EVENT_BUS.post((Event)modifierEvent);
            return this.spellStats;
        }

        public SpellStats build() {
            return this.spellStats;
        }

        public Builder setDamageModifier(double damageModifier) {
            this.spellStats.damageModifier = damageModifier;
            return this;
        }

        public Builder addDamageModifier(double damageModifier) {
            SpellStats spellStats = this.spellStats;
            spellStats.damageModifier = spellStats.damageModifier + damageModifier;
            return this;
        }

        public Builder setAugments(List<AbstractAugment> augments) {
            this.spellStats.augments = augments;
            return this;
        }

        public Builder addItemsFromEntity(@Nullable LivingEntity entity) {
            if (entity == null) {
                return this;
            }
            CuriosUtil.getAllWornItems(entity).ifPresent(e -> {
                for (int i = 0; i < e.getSlots(); ++i) {
                    ItemStack item = e.getStackInSlot(i);
                    this.spellStats.modifierItems.add(item);
                }
            });
            for (ItemStack i : entity.func_184209_aF()) {
                this.spellStats.modifierItems.add(i);
            }
            return this;
        }

        public Builder addAugment(AbstractAugment abstractAugment) {
            this.spellStats.augments.add(abstractAugment);
            return this;
        }

        public Builder setAmplification(double power) {
            this.spellStats.amplification = power;
            return this;
        }

        public Builder addAmplification(double amplification) {
            SpellStats spellStats = this.spellStats;
            spellStats.amplification = spellStats.amplification + amplification;
            return this;
        }

        public Builder setDurationModifier(double duration) {
            this.spellStats.durationMultiplier = duration;
            return this;
        }

        public Builder addDurationModifier(double duration) {
            SpellStats spellStats = this.spellStats;
            spellStats.durationMultiplier = spellStats.durationMultiplier + duration;
            return this;
        }

        public Builder setItems(List<ItemStack> items) {
            this.spellStats.modifierItems = items;
            return this;
        }

        public Builder addItem(ItemStack itemStack) {
            this.spellStats.modifierItems.add(itemStack);
            return this;
        }
    }
}

