/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.init;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="waddles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PenguinRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"waddles");
    private static final List<Item> SPAWN_EGGS = Lists.newArrayList();
    public static final RegistryObject<EntityType<AdeliePenguinEntity>> ADELIE_PENGUIN = PenguinRegistry.createEntity("adelie_penguin", AdeliePenguinEntity::new, 0.4f, 0.95f, 0, 0xFFFFFF);

    private static <T extends AnimalEntity> RegistryObject<EntityType<T>> createEntity(String name, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("waddles", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        spawnEgg.setRegistryName(new ResourceLocation("waddles", name + "_spawn_egg"));
        SPAWN_EGGS.add((Item)spawnEgg);
        return ENTITY_DEFERRED.register(name, () -> entity);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ADELIE_PENGUIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AdeliePenguinEntity::canPenguinSpawn);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ADELIE_PENGUIN.get(), AdeliePenguinEntity.createAttributes().func_233813_a_());
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : SPAWN_EGGS) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }
}

