/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.entity;

import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.init.WaddlesSounds;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AdeliePenguinEntity
extends AnimalEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});
    public short rotationFlipper;
    private boolean moveFlipper = false;

    public AdeliePenguinEntity(EntityType<? extends AdeliePenguinEntity> adelie, World world) {
        super(adelie, world);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIExtinguishFire());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, AdeliePenguinEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.16);
    }

    public float func_205022_a(@Nonnull BlockPos pos, @Nonnull IWorldReader world) {
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockDown.getRegistryName() != null && ((List)ConfigurationHandler.GENERAL.spawnBlocks.get()).contains(blockDown.getRegistryName().toString())) {
            return 10.0f;
        }
        return super.func_205022_a(pos, world);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? (SoundEvent)WaddlesSounds.ADELIE_BABY_AMBIENT.get() : (SoundEvent)WaddlesSounds.ADELIE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return (SoundEvent)WaddlesSounds.ADELIE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WaddlesSounds.ADELIE_DEATH.get();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_226277_ct_() != this.field_70166_s && this.moveFlipper) {
            this.rotationFlipper = (short)(this.rotationFlipper + 1);
        }
    }

    protected int func_70693_a(@Nonnull PlayerEntity player) {
        if (((Boolean)ConfigurationHandler.GENERAL.dropExp.get()).booleanValue()) {
            return super.func_70693_a(player);
        }
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && TEMPTATION_ITEMS.test(stack);
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        return (Boolean)ConfigurationHandler.GENERAL.dropFish.get() != false ? super.func_184647_J() : LootTables.field_186419_a;
    }

    public AgeableEntity func_241840_a(@Nonnull ServerWorld world, @Nonnull AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)PenguinRegistry.ADELIE_PENGUIN.get()).func_200721_a(this.field_70170_p);
    }

    public static boolean canPenguinSpawn(EntityType<? extends AdeliePenguinEntity> animal, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && world.func_226659_b_(pos, 0) > 8 && world.func_226660_f_(pos);
    }

    protected float func_213348_b(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return this.func_70631_g_() ? 0.5f : 0.9f;
    }

    private class EntityAIExtinguishFire
    extends PanicGoal {
        EntityAIExtinguishFire() {
            super((CreatureEntity)AdeliePenguinEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return (AdeliePenguinEntity.this.func_70631_g_() || AdeliePenguinEntity.this.func_70027_ad()) && super.func_75250_a();
        }
    }
}

