/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.client.model;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PenguinModel<T extends AdeliePenguinEntity>
extends AgeableModel<T> {
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer beak;
    private ModelRenderer flipperRight;
    private ModelRenderer flipperLeft;
    private ModelRenderer feetLeft;
    private ModelRenderer feetRight;
    private ModelRenderer tail;

    public PenguinModel() {
        super(false, 6.0f, 0.0f);
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.beak = new ModelRenderer((Model)this, 18, 0);
        this.beak.func_78793_a(0.0f, 0.0f, 0.0f);
        this.beak.func_228301_a_(-0.5f, -3.0f, -4.0f, 1.0f, 2.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.beak, 0.08726646f, -0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 0, 9);
        this.body.func_78793_a(0.0f, 12.0f, 1.0f);
        this.body.func_228301_a_(-2.5f, 0.0f, -2.0f, 5.0f, 11.0f, 5.0f, 0.0f);
        this.feetRight = new ModelRenderer((Model)this, 0, 25);
        this.feetRight.func_78793_a(-1.0f, 11.0f, 0.0f);
        this.feetRight.func_228301_a_(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.feetRight, 0.0f, 0.2617994f, 0.0f);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, 12.0f, 0.0f);
        this.head.func_228301_a_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 5.0f, 0.0f);
        this.tail = new ModelRenderer((Model)this, 20, 20);
        this.tail.func_78793_a(0.0f, 11.0f, 3.0f);
        this.tail.func_228301_a_(-1.5f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.tail, 1.2566371f, 0.0f, 0.0f);
        this.flipperRight = new ModelRenderer((Model)this, 20, 10);
        this.flipperRight.func_78793_a(-2.5f, 1.0f, 0.0f);
        this.flipperRight.func_228301_a_(-1.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.flipperRight, 0.0f, 0.0f, 0.08726646f);
        this.feetLeft = new ModelRenderer((Model)this, 0, 25);
        this.feetLeft.field_78809_i = true;
        this.feetLeft.func_78793_a(1.0f, 11.0f, 0.0f);
        this.feetLeft.func_228301_a_(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.feetLeft, 0.0f, -0.2617994f, 0.0f);
        this.flipperLeft = new ModelRenderer((Model)this, 20, 10);
        this.flipperLeft.field_78809_i = true;
        this.flipperLeft.func_78793_a(2.5f, 1.0f, 0.0f);
        this.flipperLeft.func_228301_a_(0.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.flipperLeft, 0.0f, 0.0f, -0.08726646f);
        this.head.func_78792_a(this.beak);
        this.body.func_78792_a(this.feetRight);
        this.body.func_78792_a(this.feetLeft);
        this.body.func_78792_a(this.flipperRight);
        this.body.func_78792_a(this.flipperLeft);
        this.body.func_78792_a(this.tail);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void setupAnim(@Nonnull AdeliePenguinEntity penguin, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.body.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.feetRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 1.3324f)) * 1.2f * limbSwingAmount;
        this.feetLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 1.3324f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.flipperRight.field_78808_h = 0.08726646f + MathHelper.func_76134_b((float)penguin.rotationFlipper) * limbSwingAmount;
        this.flipperLeft.field_78808_h = -0.08726646f + MathHelper.func_76134_b((float)((float)penguin.rotationFlipper + (float)Math.PI)) * limbSwingAmount;
        this.tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * 1.4f * limbSwingAmount;
    }
}

