/*
 * Decompiled with CFR 0.152.
 */
package maroonshaded.gildedarmor.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public enum ModArmorMaterial implements IArmorMaterial
{
    GILDED_NETHERITE("gilded_netherite", (IArmorMaterial)ArmorMaterial.NETHERITE),
    GILDED_ENDERITE("gilded_enderite", 8, new int[]{4, 7, 9, 4}, 17, SoundEvents.field_232681_Q_, 4.0f, 0.1f, () -> Ingredient.func_199805_a((ITag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("gildedarmor", "enderite_ingot"))), true);

    private static final int[] HEALTH_PER_SLOT;
    private static final int[] ENDERITE_HEALTH_PER_SLOT;
    private final String name;
    private final ToIntFunction<EquipmentSlotType> durability;
    private final ToIntFunction<EquipmentSlotType> protection;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ModArmorMaterial(String name, int durabilityMultiplier, int[] damageReductionAmountArray, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient, boolean useEnderiteDurability) {
        this.name = name;
        this.durability = slot -> (useEnderiteDurability ? ModArmorMaterial.getEnderiteHealthPerSlot() : ModArmorMaterial.getHealthPerSlot())[slot.func_188454_b()] * durabilityMultiplier;
        this.protection = slot -> damageReductionAmountArray[slot.func_188454_b()];
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    private ModArmorMaterial(String name, IArmorMaterial reference) {
        this.name = name;
        this.durability = arg_0 -> ((IArmorMaterial)reference).func_200896_a(arg_0);
        this.protection = arg_0 -> ((IArmorMaterial)reference).func_200902_b(arg_0);
        this.enchantmentValue = reference.func_200900_a();
        this.sound = reference.func_200899_b();
        this.toughness = reference.func_200901_e();
        this.knockbackResistance = reference.func_230304_f_();
        this.repairIngredient = () -> ((IArmorMaterial)reference).func_200898_c();
    }

    public static int[] getHealthPerSlot() {
        return HEALTH_PER_SLOT;
    }

    public static int[] getEnderiteHealthPerSlot() {
        return ENDERITE_HEALTH_PER_SLOT;
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return this.durability.applyAsInt(slotIn);
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.protection.applyAsInt(slotIn);
    }

    public int func_200900_a() {
        return this.enchantmentValue;
    }

    public SoundEvent func_200899_b() {
        return this.sound;
    }

    public Ingredient func_200898_c() {
        return this.repairIngredient.get();
    }

    public String func_200897_d() {
        return "gildedarmor:" + this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        ENDERITE_HEALTH_PER_SLOT = new int[]{128, 144, 160, 112};
    }
}

