/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackData
implements IContainerData {
    private final NonNullSupplier<ItemStack> _getter;
    private final NonNullConsumer<ItemStack> _setter;
    private ItemStack _lastValue;

    public ItemStackData(NonNullSupplier<ItemStack> getter, NonNullConsumer<ItemStack> setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = ItemStack.field_190927_a;
    }

    public static ItemStackData wrap(NonNullList<ItemStack> list, int index) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> (ItemStack)list.get(index)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> {
            ItemStack cfr_ignored_0 = (ItemStack)list.set(index, v);
        }));
    }

    public static ItemStackData wrap(IItemHandlerModifiable handler, int slot) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> handler.getStackInSlot(slot)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> handler.setStackInSlot(slot, v)));
    }

    public static ItemStackData wrap(IStackHolderAccess<ItemStackHolder, ItemStack> holder, int index) {
        return new ItemStackData((NonNullSupplier<ItemStack>)((NonNullSupplier)() -> (ItemStack)holder.getStackAt(index)), (NonNullConsumer<ItemStack>)((NonNullConsumer)v -> holder.setStackAt(index, (ItemStack)v)));
    }

    @Override
    @Nullable
    public NonNullConsumer<PacketBuffer> getContainerDataWriter() {
        ItemStack current = (ItemStack)this._getter.get();
        if (this._lastValue.func_190926_b() && current.func_190926_b()) {
            return null;
        }
        boolean equalItem = ItemHelper.stackMatch(this._lastValue, current, ItemHelper.MatchOption.MATCH_ITEM_NBT);
        if (!equalItem || current.func_190916_E() != this._lastValue.func_190916_E()) {
            this._lastValue = current.func_77946_l();
            if (equalItem) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.func_150787_b(this._lastValue.func_190916_E());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                buffer.writeItemStack(this._lastValue, true);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(PacketBuffer dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                this._setter.accept((Object)dataSource.func_150791_c());
                break;
            }
            case 1: {
                this._setter.accept((Object)ItemHelper.stackFrom((ItemStack)this._getter.get(), dataSource.func_150792_a()));
            }
        }
    }
}

