/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage2;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fml.LogicalSide;

public class WideEnergyBuffer
implements IWideEnergyStorage2,
ISyncableEntity,
IDebuggable {
    private final EnergySystem _system;
    private WideAmount _energy;
    private WideAmount _capacity;
    private WideAmount _maxInsert;
    private WideAmount _maxExtract;
    private boolean _modified;

    public WideEnergyBuffer(EnergySystem system, WideAmount capacity) {
        this(system, capacity, capacity, capacity);
    }

    public WideEnergyBuffer(EnergySystem system, WideAmount capacity, WideAmount maxTransfer) {
        this(system, capacity, maxTransfer, maxTransfer);
    }

    public WideEnergyBuffer(EnergySystem system, WideAmount capacity, WideAmount maxInsert, WideAmount maxExtract) {
        this._system = system;
        this._energy = WideAmount.ZERO;
        this._capacity = capacity;
        this._maxInsert = maxInsert;
        this._maxExtract = maxExtract;
        this._modified = false;
    }

    public boolean isEmpty() {
        return this._energy.isZero();
    }

    public boolean modified() {
        boolean m = this._modified;
        this._modified = false;
        return m;
    }

    public WideEnergyBuffer setCapacity(WideAmount capacity) {
        this._capacity = this._capacity.set(capacity);
        if (this._energy.greaterThan(capacity)) {
            this._energy = this._energy.set(capacity);
            this._modified = true;
        }
        return this;
    }

    public WideEnergyBuffer setMaxTransfer(WideAmount maxTransfer) {
        this.setMaxInsert(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public WideEnergyBuffer setMaxInsert(WideAmount maxInsert) {
        this._maxInsert = this._maxInsert.set(maxInsert);
        return this;
    }

    public WideEnergyBuffer setMaxExtract(WideAmount maxExtract) {
        this._maxExtract = this._maxExtract.set(maxExtract);
        return this;
    }

    public WideAmount getMaxInsert() {
        return this._maxInsert.copy();
    }

    public WideAmount getMaxExtract() {
        return this._maxExtract.copy();
    }

    public WideAmount getEnergyStored() {
        return this._energy.copy();
    }

    public WideEnergyBuffer setEnergyStored(WideAmount amount) {
        this._energy = this._energy.set(amount.greaterThan(this._capacity) ? this._capacity : amount);
        this._modified = true;
        return this;
    }

    public void merge(WideEnergyBuffer other) {
        if (!other.isEmpty()) {
            this._energy = this._energy.add(other._system.convertTo(this._system, other._energy));
            this._modified = true;
        }
    }

    @Override
    public EnergySystem getEnergySystem() {
        return this._system;
    }

    @Override
    public WideAmount insertEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        EnergySystem localSystem = this.getEnergySystem();
        maxAmount = system.convertTo(localSystem, maxAmount);
        WideAmount inserted = WideAmount.min(this.getCapacity(localSystem).subtract(this._energy), WideAmount.min(this._maxInsert, maxAmount)).copy();
        if (mode.execute()) {
            this._energy = this._energy.set(WideAmount.min(this.getEnergyStored(localSystem).add(inserted), this._capacity));
            this._modified = true;
        }
        return localSystem.convertTo(system, inserted);
    }

    @Override
    public WideAmount extractEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        EnergySystem localSystem = this.getEnergySystem();
        maxAmount = system.convertTo(localSystem, maxAmount);
        WideAmount extracted = WideAmount.min(this._energy, WideAmount.min(this._maxExtract, maxAmount)).copy();
        if (mode.execute()) {
            this._energy = this._energy.subtract(extracted);
            this._modified = true;
        }
        return localSystem.convertTo(system, extracted);
    }

    @Override
    public WideAmount getEnergyStored(EnergySystem system) {
        return this.convertIf(system, this._energy);
    }

    @Override
    public WideAmount getCapacity(EnergySystem system) {
        return this.convertIf(system, this._capacity);
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (data.func_74764_b("wide")) {
            this._capacity = WideAmount.from(data.func_74775_l("capacity"));
            this._maxInsert = WideAmount.from(data.func_74775_l("maxInsert"));
            this._maxExtract = WideAmount.from(data.func_74775_l("maxExtract"));
            this._energy = WideAmount.from(data.func_74775_l("energy"));
        } else {
            this.setMaxInsert(WideAmount.from(data.func_74769_h("maxInsert")));
            this.setMaxExtract(WideAmount.from(data.func_74769_h("maxExtract")));
            this.setEnergyStored(WideAmount.from(data.func_74769_h("energy")));
            this.setCapacity(WideAmount.from(data.func_74769_h("capacity")));
        }
        this._modified = true;
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        data.func_74774_a("wide", (byte)1);
        data.func_218657_a("capacity", (INBT)this._capacity.serializeTo(new CompoundNBT()));
        data.func_218657_a("maxInsert", (INBT)this._maxInsert.serializeTo(new CompoundNBT()));
        data.func_218657_a("maxExtract", (INBT)this._maxExtract.serializeTo(new CompoundNBT()));
        data.func_218657_a("energy", (INBT)this._energy.serializeTo(new CompoundNBT()));
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        EnergySystem sys = this.getEnergySystem();
        messages.add("Energy buffer: %1$s / %2$s; Imax: %3$s/t, Omax: %4$s/t", sys.asHumanReadableNumber(this._energy.doubleValue()), sys.asHumanReadableNumber(this._capacity.doubleValue()), sys.asHumanReadableNumber(this._maxInsert.doubleValue()), sys.asHumanReadableNumber(this._maxExtract.doubleValue()));
    }

    public String toString() {
        EnergySystem sys = this.getEnergySystem();
        return String.format("%s / %s - Imax: %s/t, Omax: %s/t", sys.asHumanReadableNumber(this._energy.doubleValue()), sys.asHumanReadableNumber(this._capacity.doubleValue()), sys.asHumanReadableNumber(this._maxInsert.doubleValue()), sys.asHumanReadableNumber(this._maxExtract.doubleValue()));
    }

    private WideAmount convertIf(EnergySystem system, WideAmount amount) {
        return this.getEnergySystem() != system ? this.getEnergySystem().convertTo(system, amount.copy()) : amount.copy();
    }
}

