/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotGeneric;
import java.util.List;
import net.minecraft.inventory.container.Slot;

public class SlotsGroup
extends AbstractControl {
    private final String _inventorySlotsGroupName;

    public SlotsGroup(ModContainerScreen<? extends ModContainer> gui, String name, String inventorySlotsGroupName, int width, int height, ISprite slotsBackground) {
        super(gui, name);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)inventorySlotsGroupName) ? 1 : 0) != 0);
        this._inventorySlotsGroupName = inventorySlotsGroupName;
        this.setDesiredDimension(DesiredDimension.Width, width);
        this.setDesiredDimension(DesiredDimension.Height, height);
        this.setBackground(slotsBackground);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        return false;
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        super.onMouseReleased(wnd, mouseX, mouseY, releasedButton);
        return false;
    }

    @Override
    public boolean onMouseDragged(IWindow wnd, int mouseX, int mouseY, int clickedButton, long timeSinceLastClick) {
        super.onMouseDragged(wnd, mouseX, mouseY, clickedButton, timeSinceLastClick);
        return false;
    }

    @Override
    public boolean onMouseWheel(IWindow wnd, int mouseX, int mouseY, double movement) {
        super.onMouseWheel(wnd, mouseX, mouseY, movement);
        return false;
    }

    @Override
    public boolean onMouseMoved(IWindow wnd, int mouseX, int mouseY) {
        return super.onMouseMoved(wnd, mouseX, mouseY);
    }

    @Override
    public void onMoved() {
        List<Slot> slots = ((ModContainer)this.getGui().func_212873_a_()).getInventorySlotsGroup(this._inventorySlotsGroupName);
        slots.stream().filter(slot -> slot instanceof SlotGeneric).map(slot -> (SlotGeneric)slot).forEach(slot -> slot.translate(this::translateSlot));
    }

    @Override
    public void onPaint(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getGui().renderHoveredSlotToolTip(matrix);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" group:").append(this._inventorySlotsGroupName);
    }

    private Point translateSlot(int x, int y) {
        Point p = this.controlToScreen(x + this.getPadding().getLeft(), y + this.getPadding().getTop());
        return p.offset(-this.getGui().getGuiLeft(), -this.getGui().getGuiTop());
    }
}

