/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.base.client.screen.control.AbstractVerticalIconGaugeBar;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar
extends AbstractVerticalIconGaugeBar {
    public FluidBar(ModContainerScreen<? extends ModContainer> gui, String name, double maxValue, Supplier<Double> valueSupplier, Supplier<FluidStack> fluidSupplier, NonNullSupplier<ISprite> iconSprite, String titleTooltipLine, @Nullable String optionalTooltipLine) {
        super(gui, name, maxValue, valueSupplier, (NonNullSupplier<ISprite>)((NonNullSupplier)() -> Sprite.EMPTY), iconSprite);
        BindableTextComponent valueText = new BindableTextComponent(this::getValueText);
        BindableTextComponent percentageText = new BindableTextComponent(this::getPercentageText);
        BindableTextComponent fluidNameText = new BindableTextComponent(BaseHelper::getFluidNameOrEmpty);
        ImmutableList.Builder tipsBuilder = ImmutableList.builder();
        tipsBuilder.add((Object[])new ITextComponent[]{new TranslationTextComponent(titleTooltipLine).func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent("gui.zerocore.base.control.fluidbar.line2").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE), new TranslationTextComponent("gui.zerocore.base.control.fluidbar.line3a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.zerocore.base.control.fluidbar.line3b", new Object[]{CodeHelper.formatAsMillibuckets((float)maxValue)})), new TranslationTextComponent("gui.zerocore.base.control.fluidbar.line4a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.zerocore.base.control.fluidbar.line4b"))});
        if (!Strings.isNullOrEmpty((String)optionalTooltipLine)) {
            tipsBuilder.add((Object)new TranslationTextComponent(optionalTooltipLine));
        }
        this._bar.setTooltips((List<ITextComponent>)tipsBuilder.build(), (List<Object>)ImmutableList.of(fluidNameText, valueText, percentageText));
        gui.addDataBinding(valueSupplier, valueText, percentageText);
        gui.addDataBinding(fluidSupplier, fluidNameText, this::setFluidSprite);
        this._icon.useTooltipsFrom(this._bar);
    }

    private ITextComponent getValueText(double amount) {
        return new StringTextComponent(CodeHelper.formatAsMillibuckets((float)amount)).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE);
    }

    private ITextComponent getPercentageText(double amount) {
        return new StringTextComponent(String.format("%d", (int)(amount / this._bar.getMaxValue() * 100.0))).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE);
    }

    private void setFluidSprite(FluidStack stack) {
        if (stack.isEmpty()) {
            this._bar.setBarSprite(Sprite.EMPTY);
            this._bar.setBarSpriteTint(Colour.WHITE);
        } else {
            Fluid fluid = stack.getFluid();
            ISprite fluidSprite = ModRenderHelper.getStillFluidSprite(fluid);
            Colour fluidTint = Colour.fromARGB(fluid.getAttributes().getColor());
            this._bar.setBarSprite(fluidSprite);
            this._bar.setBarSpriteTint(fluidTint);
        }
    }
}

