/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.itemcollectors.ClientProxy;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class CollectorBlock
extends BaseBlock {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.field_208155_H;
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)10.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    private static final BlockShape[] SHAPES = new BlockShape[6];
    private final Supplier<CollectorTile> tileSupplier;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;

    public CollectorBlock(String registryName, Supplier<CollectorTile> tileSupplier, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(registryName, false, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 1200.0f));
        this.tileSupplier = tileSupplier;
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(DIRECTION, (Comparable)Direction.DOWN));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (worldIn.field_72995_K && !this.hasFilter.get().booleanValue()) {
            ClientProxy.openBasicCollectorScreen(pos);
        } else if (!worldIn.field_72995_K && this.hasFilter.get().booleanValue()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return TextComponents.empty().get();
                }

                @Nullable
                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new AdvancedCollectorContainer(id, player, pos);
                }
            }, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return (TileEntity)this.tileSupplier.get();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(DIRECTION)).func_176745_a()].getUnderlying();
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TextComponents.translation((String)("itemcollectors." + (this.hasFilter.get() != false ? "advanced" : "basic") + "_collector.info"), (Object[])new Object[]{this.maxRange.get()}).color(TextFormatting.AQUA).get());
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(DIRECTION, (Comparable)context.func_196000_l().func_176734_d());
    }

    static {
        CollectorBlock.SHAPES[Direction.DOWN.func_176745_a()] = SHAPE;
        CollectorBlock.SHAPES[Direction.UP.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.NORTH.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.EAST.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.SOUTH.func_176745_a()] = SHAPE.rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.WEST.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y);
    }
}

