/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.log4jpatcher;

import net.creeperhost.log4jpatcher.Transformer;
import net.creeperhost.repack.org.objectweb.asm.tree.ClassNode;
import net.creeperhost.repack.org.objectweb.asm.tree.MethodNode;

public class JndiLookupTransformer
extends Transformer {
    private static final String CLASS_NAME = "org/apache/logging/log4j/core/lookup/JndiLookup";
    private static final String LOOKUP_DESC = "(Lorg/apache/logging/log4j/core/LogEvent;Ljava/lang/String;)Ljava/lang/String;";

    @Override
    public byte[] transform(String cName, byte[] bytes) {
        if (!CLASS_NAME.equals(cName)) {
            return bytes;
        }
        logger.println("[Log4jPatcher] [INFO] Transforming " + cName);
        ClassNode cNode = this.parseClassNode(bytes);
        MethodNode lookupMethod = this.findMethod(cNode, "lookup", LOOKUP_DESC);
        if (lookupMethod == null) {
            logger.println("[Log4jPatcher] [WARN]  Unable to find 'lookup(Lorg/apache/logging/log4j/core/LogEvent;Ljava/lang/String;)Ljava/lang/String;' method in " + cName);
            return bytes;
        }
        lookupMethod.instructions.clear();
        lookupMethod.tryCatchBlocks.clear();
        lookupMethod.visitInsn(1);
        lookupMethod.visitInsn(176);
        lookupMethod.visitMaxs(-1, -1);
        return this.writeClass(cNode, 1);
    }
}

