/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.infuse;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.ChemicalChannelSettings;
import terrails.xnetgases.module.infuse.InfuseConnectorSettings;
import terrails.xnetgases.module.infuse.InfuseUtils;

public class InfuseChannelSettings
extends ChemicalChannelSettings {
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private List<Pair<SidedConsumer, InfuseConnectorSettings>> infuseExtractors;
    private List<Pair<SidedConsumer, InfuseConnectorSettings>> infuseConsumers;

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = InfuseUtils.getChannelModeFrom(data.get("mode").getAsString());
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.channelMode = ChannelMode.values()[nbt.func_74771_c("mode")];
        this.delay = nbt.func_74762_e("delay");
        this.roundRobinOffset = nbt.func_74762_e("offset");
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74774_a("mode", (byte)this.channelMode.ordinal());
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74768_a("offset", this.roundRobinOffset);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 == 0) {
            int d = this.delay / 10;
            this.updateCache(channel, context);
            World world = context.getControllerWorld();
            block0: for (Pair<SidedConsumer, InfuseConnectorSettings> entry : this.infuseExtractors) {
                InfusionStack stack;
                TileEntity te;
                Optional<IInfusionHandler> optional;
                BlockPos pos;
                BlockPos extractorPos;
                SidedConsumer consumer = (SidedConsumer)entry.getFirst();
                InfuseConnectorSettings settings = (InfuseConnectorSettings)((Object)entry.getSecond());
                if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(consumer.getSide()))) || !(optional = InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos)), settings.getFacing())).isPresent()) continue;
                IInfusionHandler handler = optional.get();
                if (this.checkRedstone(world, settings, extractorPos)) {
                    return;
                }
                if (!context.matchColor(settings.getColorsMask())) {
                    return;
                }
                InfusionStack extractMatcher = settings.getMatcher();
                long toExtract = settings.getRate().intValue();
                Integer count = settings.getMinmax();
                if (count != null) {
                    long amount = InfuseUtils.getInfuseCount(handler, settings.getFacing(), extractMatcher);
                    long canExtract = amount - (long)count.intValue();
                    if (canExtract <= 0L) continue;
                    toExtract = Math.min(toExtract, canExtract);
                }
                if (this.channelMode == ChannelMode.PRIORITY && this.infuseExtractors.stream().anyMatch(_entry -> {
                    SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                    InfuseConnectorSettings _settings = (InfuseConnectorSettings)((Object)((Object)_entry.getSecond()));
                    if (_settings.getPriority() <= settings.getPriority()) {
                        return false;
                    }
                    BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                    if (_extractorPos == null) {
                        return false;
                    }
                    BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                    if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                        return false;
                    }
                    Optional<IInfusionHandler> _optional = InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                    if (_optional.isPresent()) {
                        List<InfuseType> _handlerInfuses;
                        IInfusionHandler _handler = _optional.get();
                        List<InfuseType> handlerInfuses = InfuseUtils.getInfuseInTank(handler, consumer.getSide());
                        if (Collections.disjoint(handlerInfuses, _handlerInfuses = InfuseUtils.getInfuseInTank(_handler, _consumer.getSide()))) {
                            return false;
                        }
                        InfusionStack matcher = settings.getMatcher();
                        InfusionStack _matcher = _settings.getMatcher();
                        return !(matcher != null && !handlerInfuses.contains(matcher.getType()) || _matcher != null && !_handlerInfuses.contains(_matcher.getType()));
                    }
                    return false;
                })) continue;
                ArrayList<Pair<SidedConsumer, InfuseConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, InfuseConnectorSettings>>();
                while (!(stack = InfuseUtils.extractInfuse(handler, toExtract, settings.getFacing(), Action.SIMULATE)).isEmpty() && (extractMatcher == null || extractMatcher.isTypeEqual((ChemicalStack)stack))) {
                    toExtract = stack.getAmount();
                    inserted.clear();
                    long remaining = this.insertInfuseSimulate(inserted, context, stack);
                    if (inserted.isEmpty() || (toExtract -= remaining) <= 0L) continue block0;
                    if (remaining > 0L) continue;
                    if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) continue block0;
                    stack = InfuseUtils.extractInfuse(handler, toExtract, settings.getFacing(), Action.EXECUTE);
                    if (stack.isEmpty()) {
                        throw new NullPointerException(handler.getClass().getName() + " misbehaved! handler.extractInfuse(" + toExtract + ", Action.SIMULATE) returned null, even though handler.extractInfuse(" + toExtract + ", Action.EXECUTE) did not");
                    }
                    this.insertInfuseReal(context, inserted, stack);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void cleanCache() {
        this.infuseExtractors = null;
        this.infuseConsumers = null;
    }

    private long insertInfuseSimulate(@Nonnull List<Pair<SidedConsumer, InfuseConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull InfusionStack stack) {
        World world = context.getControllerWorld();
        long amount = stack.getAmount();
        for (int j = 0; j < this.infuseConsumers.size(); ++j) {
            BlockPos pos;
            TileEntity te;
            Optional<IInfusionHandler> optional;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.infuseConsumers.size();
            Pair<SidedConsumer, InfuseConnectorSettings> entry = this.infuseConsumers.get(i);
            SidedConsumer consumer = (SidedConsumer)entry.getFirst();
            InfuseConnectorSettings settings = (InfuseConnectorSettings)((Object)entry.getSecond());
            if (settings.getMatcher() != null && !settings.getMatcher().isTypeEqual((ChemicalStack)stack) || (consumerPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || !(optional = InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos = consumerPos.func_177972_a(consumer.getSide()))), settings.getFacing())).isPresent()) continue;
            IInfusionHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = InfuseUtils.getInfuseCount(handler, settings.getFacing(), settings.getMatcher());
                long canInsert = (long)count.intValue() - a;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            if (this.channelMode == ChannelMode.PRIORITY && this.infuseConsumers.stream().anyMatch(_entry -> {
                SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                InfuseConnectorSettings _settings = (InfuseConnectorSettings)((Object)((Object)_entry.getSecond()));
                if (_settings.getPriority() <= settings.getPriority()) {
                    return false;
                }
                BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                if (_extractorPos == null) {
                    return false;
                }
                BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                    return false;
                }
                Optional<IInfusionHandler> _optional = InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                if (_optional.isPresent()) {
                    List<InfuseType> _handlerInfuses;
                    IInfusionHandler _handler = _optional.get();
                    List<InfuseType> handlerInfuses = InfuseUtils.getInfuseInTank(handler, consumer.getSide());
                    if (Collections.disjoint(handlerInfuses, _handlerInfuses = InfuseUtils.getInfuseInTank(_handler, _consumer.getSide()))) {
                        return false;
                    }
                    InfusionStack matcher = settings.getMatcher();
                    InfusionStack _matcher = _settings.getMatcher();
                    return !(matcher != null && !handlerInfuses.contains(matcher.getType()) || _matcher != null && !_handlerInfuses.contains(_matcher.getType()));
                }
                return false;
            })) continue;
            InfusionStack copy = stack.copy();
            copy.setAmount(toInsert);
            InfusionStack remaining = InfuseUtils.insertInfuse(handler, copy, settings.getFacing(), Action.SIMULATE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            inserted.add(entry);
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return 0L;
        }
        return amount;
    }

    private void insertInfuseReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, InfuseConnectorSettings>> inserted, @Nonnull InfusionStack stack) {
        long amount = stack.getAmount();
        for (Pair<SidedConsumer, InfuseConnectorSettings> pair : inserted) {
            InfuseConnectorSettings settings = (InfuseConnectorSettings)((Object)pair.getSecond());
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)pair.getFirst()).getConsumerId());
            assert (consumerPosition != null);
            BlockPos pos = consumerPosition.func_177972_a(((SidedConsumer)pair.getFirst()).getSide());
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            Optional<IInfusionHandler> optional = InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)te, settings.getFacing());
            if (!optional.isPresent()) continue;
            IInfusionHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = InfuseUtils.getInfuseCount(handler, settings.getFacing(), settings.getMatcher());
                long caninsert = (long)count.intValue() - a;
                if (caninsert <= 0L) continue;
                toInsert = Math.min(toInsert, caninsert);
            }
            InfusionStack copy = stack.copy();
            copy.setAmount(toInsert);
            InfusionStack remaining = InfuseUtils.insertInfuse(handler, copy, settings.getFacing(), Action.EXECUTE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.infuseConsumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.infuseExtractors == null) {
            InfuseConnectorSettings settings;
            SidedConsumer consumer;
            this.infuseExtractors = new ArrayList<Pair<SidedConsumer, InfuseConnectorSettings>>();
            this.infuseConsumers = new ArrayList<Pair<SidedConsumer, InfuseConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (InfuseConnectorSettings)((Object)entry.getValue());
                if (settings.getInfuseMode() == InfuseConnectorSettings.InfuseMode.EXT) {
                    this.infuseExtractors.add((Pair<SidedConsumer, InfuseConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
                    continue;
                }
                this.infuseConsumers.add((Pair<SidedConsumer, InfuseConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)settings)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (InfuseConnectorSettings)((Object)entry.getValue());
                if (settings.getInfuseMode() != InfuseConnectorSettings.InfuseMode.INS) continue;
                this.infuseConsumers.add((Pair<SidedConsumer, InfuseConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
            }
            this.infuseConsumers.sort((o1, o2) -> ((InfuseConnectorSettings)((Object)((Object)o2.getSecond()))).getPriority().compareTo(((InfuseConnectorSettings)((Object)((Object)o1.getSecond()))).getPriority()));
        }
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices("mode", "Infuse distribution mode", (Enum)this.channelMode, (Enum[])ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get("mode")).toUpperCase());
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

    }
}

