/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.sdrp.discord;

import com.sunekaer.mods.sdrp.config.Config;
import com.sunekaer.mods.sdrp.discord.discordipc.IPCClient;
import com.sunekaer.mods.sdrp.discord.discordipc.entities.DiscordBuild;
import com.sunekaer.mods.sdrp.discord.discordipc.entities.RichPresence;
import com.sunekaer.mods.sdrp.discord.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscordRichPresence {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    private static State currentState;
    private static final IPCClient CLIENT;
    private static boolean isEnabled;
    private static int errorCount;
    private static final ScheduledExecutorService EXECUTOR_SERVICE;
    private static final Runnable TIMER_TASK;
    public static HashMap<String, State> map;

    public static void start() {
        Util.func_215072_e().execute(() -> {
            try {
                CLIENT.connect(new DiscordBuild[0]);
                EXECUTOR_SERVICE.scheduleAtFixedRate(TIMER_TASK, 1000L, 120000L, TimeUnit.MILLISECONDS);
                isEnabled = true;
                State state = DiscordRichPresence.getCurrent();
                if (state == null || state != map.get("loading")) {
                    DiscordRichPresence.setState(map.get("loading"));
                }
                LOGGER.info("Discord client found and connected.");
            }
            catch (NoDiscordClientException ex) {
                LOGGER.info("Discord client was not found.");
            }
        });
    }

    public static void stop() {
        try {
            CLIENT.close();
        }
        catch (Exception ex) {
            LOGGER.error("Error closing Discord connection.", (Throwable)ex);
        }
        errorCount = 0;
        isEnabled = false;
        LOGGER.info("Discord client closed.");
    }

    public static void setDimension(World world) {
        State dim = map.get(world.func_234923_W_().func_240901_a_().toString());
        if (dim != null) {
            DiscordRichPresence.setState(dim);
        } else if (dim == null) {
            String name = I18n.func_135052_a((String)("sdrp." + world.func_234923_W_().func_240901_a_().func_110623_a()), (Object[])new Object[0]);
            String in = I18n.func_135052_a((String)("sdrp." + world.func_234923_W_().func_240901_a_().func_110623_a() + ".in"), (Object[])new Object[0]);
            String key = world.func_234923_W_().func_240901_a_().func_110623_a();
            State dim2 = new State(in, name, key);
            DiscordRichPresence.setState(dim2);
        }
    }

    public static void setState(State state) {
        if (state == null) {
            return;
        }
        Util.func_215072_e().execute(() -> {
            block6: {
                currentState = state;
                RichPresence.Builder builder = new RichPresence.Builder();
                builder.setState(state.message);
                builder.setStartTimestamp(TIME);
                String name = I18n.func_135052_a((String)"sdrp.logo", (Object[])new Object[0]);
                builder.setLargeImage("logo", name);
                builder.setSmallImage(state.imageKey, state.imageName);
                try {
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex);
                    try {
                        CLIENT.connect(new DiscordBuild[0]);
                        errorCount = 0;
                        CLIENT.sendRichPresence(builder.build());
                    }
                    catch (Exception ex2) {
                        try {
                            CLIENT.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (++errorCount <= 10) break block6;
                        LOGGER.info("DiscordRP connection failed.");
                        DiscordRichPresence.stop();
                    }
                }
            }
        });
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    static {
        CLIENT = new IPCClient((Long)Config.CONFIG.clientID.get());
        isEnabled = false;
        errorCount = 0;
        EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
        TIMER_TASK = () -> {
            if (currentState != null && CLIENT.getStatus() == IPCClient.Status.CONNECTED) {
                DiscordRichPresence.setState(currentState);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("Shutting down Discord Rich Presence client");
            DiscordRichPresence.stop();
            try {
                EXECUTOR_SERVICE.shutdown();
            }
            catch (RuntimeException error) {
                LOGGER.error("Error shutting down Discord Rich Presence timer", (Throwable)error);
            }
        }, "DiscordRP Stop"));
        map = new HashMap();
        map.put("loading", new State("Starting Minecraft", "Starting Minecraft", "loading"));
        map.put("menu", new State("Main Menu", "Main Menu", "menu"));
    }

    public static class State {
        public String message;
        public String imageName;
        public String imageKey;

        public State(String m, String n, String k) {
            this.message = m;
            this.imageName = n;
            this.imageKey = k;
        }
    }
}

