/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.partyparrots.client.core;

import java.util.Map;
import java.util.WeakHashMap;
import me.ichun.mods.partyparrots.common.PartyParrots;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TwerkHandler {
    public static WeakHashMap<PlayerEntity, TwerkInfo> playerTwerks = new WeakHashMap();

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof ParrotEntity) {
            ParrotEntity parrot = (ParrotEntity)event.getEntity();
            if (((Boolean)PartyParrots.config.partyTwerk.get()).booleanValue() && this.withinTwerkRange(parrot)) {
                parrot.field_192018_bL = true;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END && event.player.func_225608_bj_() && !playerTwerks.containsKey(event.player)) {
            playerTwerks.put(event.player, new TwerkInfo());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T()) {
            playerTwerks.entrySet().removeIf(e -> !((TwerkInfo)e.getValue()).tick((PlayerEntity)e.getKey()));
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        Minecraft.func_71410_x().execute(this::clean);
    }

    @SubscribeEvent
    public void onLoggedOutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Minecraft.func_71410_x().execute(this::clean);
    }

    public void clean() {
        playerTwerks.clear();
    }

    public boolean withinTwerkRange(ParrotEntity parrot) {
        for (Map.Entry<PlayerEntity, TwerkInfo> e : playerTwerks.entrySet()) {
            if (!e.getValue().isTwerking() || !((double)parrot.func_70032_d((Entity)e.getKey()) < (Double)PartyParrots.config.partyTwerkRange.get())) continue;
            return true;
        }
        return false;
    }

    public class TwerkInfo {
        public int twerks = 1;
        public boolean playerSneak = true;
        public int twerkTimeout;

        public boolean tick(PlayerEntity player) {
            if (player.field_70128_L) {
                return false;
            }
            if (player.func_225608_bj_() && !this.playerSneak) {
                ++this.twerks;
                this.twerkTimeout = 0;
            }
            ++this.twerkTimeout;
            if (this.twerkTimeout > 60) {
                return false;
            }
            this.playerSneak = player.func_225608_bj_();
            return true;
        }

        public boolean isTwerking() {
            return this.twerks >= 5;
        }
    }
}

