/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.Lollipop;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.logistics.inventory.ISidedHopper;
import owmii.lib.network.IPacket;

public class NextTransferConfigPacket
implements IPacket<NextTransferConfigPacket> {
    private int i;
    private BlockPos pos;

    public NextTransferConfigPacket(int i, BlockPos pos) {
        this.i = i;
        this.pos = pos;
    }

    public NextTransferConfigPacket() {
        this(0, BlockPos.field_177992_a);
    }

    public static void send(int i, BlockPos pos) {
        Lollipop.NET.toServer(new NextTransferConfigPacket(i, pos));
    }

    @Override
    public void encode(NextTransferConfigPacket msg, PacketBuffer buffer) {
        buffer.writeInt(msg.i);
        buffer.func_179255_a(msg.pos);
    }

    @Override
    public NextTransferConfigPacket decode(PacketBuffer buffer) {
        return new NextTransferConfigPacket(buffer.readInt(), buffer.func_179259_c());
    }

    @Override
    public void handle(NextTransferConfigPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (te = player.field_70170_p.func_175625_s(msg.pos)) instanceof ISidedHopper && te instanceof AbstractTileEntity) {
                ISidedHopper handler = (ISidedHopper)te;
                if (msg.i > 5) {
                    handler.getHopperConfig().nextTypeAll();
                } else {
                    handler.getHopperConfig().nextType(Direction.func_82600_a((int)msg.i));
                }
                ((AbstractTileEntity)te).sync();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

