/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics.inventory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import owmii.lib.logistics.inventory.Hopper;
import owmii.lib.logistics.inventory.Inventory;

public class SidedHopper {
    private final Hopper[] hoppers = new Hopper[6];
    private final Inventory inv;

    public SidedHopper(Inventory inv) {
        this.inv = inv;
        for (int i = 0; i < this.hoppers.length; ++i) {
            this.hoppers[i] = new Hopper(inv);
        }
    }

    public void read(CompoundNBT nbt, String key) {
        for (int i = 0; i < this.hoppers.length; ++i) {
            Direction side = Direction.values()[i];
            this.hoppers[i].read(nbt, key + "_" + side.func_176742_j());
        }
    }

    public CompoundNBT write(CompoundNBT nbt, String key) {
        for (int i = 0; i < this.hoppers.length; ++i) {
            Direction side = Direction.values()[i];
            this.hoppers[i].write(nbt, key + "_" + side.func_176742_j());
        }
        return nbt;
    }

    public void switchPull(Direction side) {
        this.getHopper(side).switchPull();
    }

    public void switchPush(Direction side) {
        this.getHopper(side).switchPush();
    }

    public boolean canPull(Direction side) {
        return this.getHopper(side).canPull();
    }

    public boolean canPush(Direction side) {
        return this.getHopper(side).canPush();
    }

    public void setPull(Direction side, boolean pull) {
        this.getHopper(side).setPull(pull);
    }

    public void setPush(Direction side, boolean push) {
        this.getHopper(side).setPush(push);
    }

    public Map<Direction, Hopper> getActiveHoppers() {
        HashMap<Direction, Hopper> hoppers = new HashMap<Direction, Hopper>();
        for (int i = 0; i < this.hoppers.length; ++i) {
            Hopper hopper = this.hoppers[i];
            if (!hopper.isActive()) continue;
            hoppers.put(Direction.func_82600_a((int)i), hopper);
        }
        return hoppers;
    }

    public Hopper getHopper(Direction side) {
        return this.hoppers[side.func_176745_a()];
    }

    public Hopper[] getHoppers() {
        return this.hoppers;
    }
}

