/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.ModContent;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ReColourRecipe
extends RecipeBase {
    private Ingredient ingredient;

    public ReColourRecipe(ResourceLocation id, String group, @Nonnull ItemStack result, Ingredient ingredient) {
        super(id, group, result, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{ingredient}));
        this.ingredient = ingredient;
    }

    @Override
    public ItemStack assemble(CraftingInventory inv) {
        int foundRow = 0;
        Frequency currFreq = new Frequency();
        for (int row = 1; row < 3; ++row) {
            ItemStack stack = inv.func_70301_a(1 + row * inv.func_174922_i());
            if (!this.ingredient.test(stack)) continue;
            foundRow = row;
            currFreq = Frequency.readFromStack(stack);
            break;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < foundRow; ++row) {
                EnumColour colour;
                ItemStack stack = inv.func_70301_a(col + row * inv.func_174922_i());
                if (stack.func_190926_b() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                colours[col] = colours[col] == null ? colour : EnumColour.mix((EnumColour)colours[col], (EnumColour)colour);
            }
        }
        currFreq.setLeft(colours[0]);
        currFreq.setMiddle(colours[1]);
        currFreq.setRight(colours[2]);
        return currFreq.writeToStack(super.assemble(inv));
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack stack;
        int row;
        int col;
        if (inv.func_191420_l()) {
            return false;
        }
        boolean inputFound = false;
        int foundRow = 0;
        for (int row2 = 1; row2 < 3; ++row2) {
            ItemStack stack2 = inv.func_70301_a(1 + row2 * inv.func_174922_i());
            if (stack2.func_190926_b() || !this.ingredient.test(stack2)) continue;
            foundRow = row2;
            inputFound = true;
            break;
        }
        if (!inputFound) {
            return false;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        boolean hasDye = false;
        for (col = 0; col < 3; ++col) {
            for (row = 0; row < foundRow; ++row) {
                EnumColour colour;
                stack = inv.func_70301_a(col + row * inv.func_174922_i());
                if (stack.func_190926_b() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                if (colours[col] != null) {
                    EnumColour merge = EnumColour.mix((EnumColour)colours[col], (EnumColour)colour);
                    if (merge == null || merge == colour) {
                        return false;
                    }
                    colours[col] = merge;
                    continue;
                }
                hasDye = true;
                colours[col] = colour;
            }
        }
        if (hasDye) {
            for (col = 0; col < 3; ++col) {
                for (row = 0; row < 3; ++row) {
                    stack = inv.func_70301_a(col + row * inv.func_174922_i());
                    if (stack.func_190926_b()) continue;
                    if (row >= foundRow && EnumColour.fromDyeStack((ItemStack)stack) != null) {
                        return false;
                    }
                    if (this.ingredient.test(stack) || EnumColour.fromDyeStack((ItemStack)stack) != null) continue;
                    return false;
                }
            }
        }
        return hasDye;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModContent.reColourRecipeSerializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ReColourRecipe> {
        public ReColourRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            JsonElement ing = json.get("ingredient");
            Ingredient ingredient = ing != null ? Ingredient.func_199802_a((JsonElement)ing) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{result});
            return new ReColourRecipe(recipeId, group, result, ingredient);
        }

        @Nullable
        public ReColourRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ing = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return new ReColourRecipe(recipeId, s, result, ing);
        }

        public void toNetwork(PacketBuffer buffer, ReColourRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
        }
    }
}

