/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class StateStack {
    private static final ThreadLocal<List<String>> CURRENT_STACK = ThreadLocal.withInitial(ArrayList::new);

    public static Entry push(String state) {
        List<String> threadStack = CURRENT_STACK.get();
        threadStack.add(state);
        return new Entry(state, threadStack.size() - 1);
    }

    public static String formatAndClear() {
        int corner = 9492;
        StringBuilder result = new StringBuilder();
        List<String> threadStack = CURRENT_STACK.get();
        String spacePrefix = "";
        for (int i = 0; i < threadStack.size(); ++i) {
            String element = threadStack.get(i);
            if (i > 0) {
                result.append(spacePrefix).append('\u2514').append(' ');
            }
            result.append(element).append('\n');
            if (i <= 0) continue;
            spacePrefix = spacePrefix + ' ';
        }
        threadStack.clear();
        return result.toString();
    }

    public static void assertEmpty() {
        if (!CURRENT_STACK.get().isEmpty()) {
            throw new IllegalStateException("Expected empty stack (see log for current state stack)");
        }
    }

    public static class Entry {
        private final String name;
        private final int expectedIndexAtPop;
        private boolean popped = false;

        public Entry(String name, int expectedIndexAtPop) {
            this.name = name;
            this.expectedIndexAtPop = expectedIndexAtPop;
        }

        public void pop() {
            Preconditions.checkState((!this.popped ? 1 : 0) != 0);
            List threadStack = (List)CURRENT_STACK.get();
            int indexToRemove = threadStack.size() - 1;
            Preconditions.checkState((indexToRemove == this.expectedIndexAtPop ? 1 : 0) != 0, (Object)("Expected to pop \"" + this.name + "\" at index " + this.expectedIndexAtPop + ", but index is " + indexToRemove));
            String elementToRemove = (String)threadStack.get(indexToRemove);
            Preconditions.checkState((boolean)elementToRemove.equals(this.name), (Object)("Tried to pop \"" + this.name + "\", but last element is \"" + elementToRemove + "\""));
            threadStack.remove(indexToRemove);
            this.popped = true;
        }
    }
}

