/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import malte0811.recipebuffers.impl.ResourceLocationSerializer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OptimizedPacketBuffer
extends PacketBuffer {
    int itemStackBytes = 0;
    final ResourceLocationSerializer resourceLocationSerializer;
    private static final int CONSTRUCTOR_TAG = 13;

    public OptimizedPacketBuffer(ByteBuf wrapped, boolean reading) {
        super(wrapped);
        this.resourceLocationSerializer = new ResourceLocationSerializer(this, reading);
    }

    @Nonnull
    public ResourceLocation func_192575_l() {
        return this.resourceLocationSerializer.read();
    }

    @Nonnull
    public PacketBuffer func_192572_a(@Nonnull ResourceLocation toWrite) {
        this.resourceLocationSerializer.write(toWrite);
        return this;
    }

    @Nonnull
    public PacketBuffer writeItemStack(ItemStack stack, boolean limitedTag) {
        int oldIndex = this.writerIndex();
        Item item = stack.func_77973_b();
        this.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)item);
        if (!stack.func_190926_b()) {
            this.writeByte(stack.func_190916_E());
            if (ItemStack.func_77970_a((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)item))) {
                this.writeByte(13);
            } else {
                CompoundNBT compoundnbt = null;
                if (item.isDamageable(stack) || item.func_77651_p()) {
                    compoundnbt = limitedTag ? stack.getShareTag() : stack.func_77978_p();
                }
                this.func_150786_a(compoundnbt);
            }
        }
        this.itemStackBytes += this.writerIndex() - oldIndex;
        return this;
    }

    @Nonnull
    public ItemStack func_150791_c() {
        CompoundNBT tag;
        Item item = (Item)this.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        byte count = this.readByte();
        ItemStack itemstack = new ItemStack((IItemProvider)item, (int)count);
        int oldIndex = this.readerIndex();
        byte tagByte = this.readByte();
        if (tagByte == 13) {
            tag = itemstack.func_77978_p();
        } else {
            this.readerIndex(oldIndex);
            tag = this.func_150793_b();
        }
        itemstack.readShareTag(tag);
        return itemstack;
    }

    static {
        String tagName = NBTTypes.func_229710_a_((int)13).func_225650_b_();
        Preconditions.checkState((boolean)tagName.startsWith("UNKNOWN_"), (Object)("Unexpected NBT type: " + tagName));
    }
}

