/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.impl;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import malte0811.recipebuffers.RecipeBuffers;
import malte0811.recipebuffers.util.StateStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.HexDumper;

public class ErrorLogger {
    private static final int BYTES_EITHER_WAY = 200;

    public static void logReadError(Throwable error, PacketBuffer currentBufferState, int startIndex) {
        ErrorLogger.printSanitizedExceptionAndStateStack(error);
        int currentIndex = currentBufferState.readerIndex();
        int outputStartIndex = Math.max(startIndex, currentIndex - 200);
        int outputLength = currentIndex - outputStartIndex + Math.min(currentBufferState.readableBytes(), 200);
        byte[] bytesToWrite = new byte[outputLength];
        currentBufferState.getBytes(outputStartIndex, bytesToWrite);
        RecipeBuffers.LOGGER.info("Bytes before current position:\n{}", (Object)ErrorLogger.hexdump(bytesToWrite, 0, currentIndex - outputStartIndex));
        RecipeBuffers.LOGGER.info("Bytes after current position:\n{}", (Object)ErrorLogger.hexdump(bytesToWrite, currentIndex - outputStartIndex, bytesToWrite.length));
    }

    public static void logWriteError(Throwable error, PacketBuffer currentBufferState, int startIndex) {
        ErrorLogger.printSanitizedExceptionAndStateStack(error);
        int currentIndex = currentBufferState.writerIndex();
        int outputIndex = Math.max(currentIndex - 200, startIndex);
        byte[] bytesToWrite = new byte[currentIndex - outputIndex];
        currentBufferState.getBytes(outputIndex, bytesToWrite);
        RecipeBuffers.LOGGER.info("Last bytes written:\n{}", (Object)ErrorLogger.hexdump(bytesToWrite, 0, bytesToWrite.length));
    }

    private static void printSanitizedExceptionAndStateStack(Throwable error) {
        CharArrayList specialAllowed = new CharArrayList(new char[]{'\n', '\r', '\t'});
        ByteArrayOutputStream rawException = new ByteArrayOutputStream();
        error.printStackTrace(new PrintStream(rawException));
        StringBuilder toWrite = new StringBuilder(rawException.size());
        int numUnprintable = 0;
        for (byte b : rawException.toByteArray()) {
            int value = b & 0xFF;
            if (!(value >= 32 && value != 255 || specialAllowed.contains((char)value))) {
                ++numUnprintable;
                toWrite.append('<').append(Integer.toHexString(value)).append('>');
                continue;
            }
            toWrite.append((char)value);
        }
        RecipeBuffers.LOGGER.info("Sanitized exception (replaced {} characters):\n{}", (Object)numUnprintable, (Object)toWrite);
        RecipeBuffers.LOGGER.info("State stack at error:\n{}", (Object)StateStack.formatAndClear());
    }

    private static String hexdump(byte[] bytes, int start, int end) {
        byte[] subBytes = Arrays.copyOfRange(bytes, start, end);
        return HexDumper.dump((byte[])subBytes);
    }
}

