/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import malte0811.recipebuffers.impl.RecurringShapedSerializer;
import malte0811.recipebuffers.impl.RecurringShapelessSerializer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="recipebuffers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RBRecipeSerializers {
    private static final Map<IRecipeSerializer<?>, IRecipeSerializer<?>> REPLACEMENTS = new Object2ObjectArrayMap();

    @SubscribeEvent
    public static void registerSerializers(RegistryEvent.Register<IRecipeSerializer<?>> ev) {
        RecurringShapelessSerializer recurringShapeless = new RecurringShapelessSerializer();
        recurringShapeless.setRegistryName("recipebuffers", "shapeless");
        ev.getRegistry().register((IForgeRegistryEntry)recurringShapeless);
        RBRecipeSerializers.replace(IRecipeSerializer.field_222158_b, recurringShapeless);
        RecurringShapedSerializer recurringShaped = new RecurringShapedSerializer();
        recurringShaped.setRegistryName("recipebuffers", "shaped");
        ev.getRegistry().register((IForgeRegistryEntry)recurringShaped);
        RBRecipeSerializers.replace(IRecipeSerializer.field_222157_a, recurringShaped);
    }

    private static <T extends IRecipe<?>> void replace(IRecipeSerializer<T> oldSer, IRecipeSerializer<T> newSer) {
        REPLACEMENTS.put(oldSer, newSer);
    }

    public static IRecipeSerializer<?> getSerializer(IRecipeSerializer<?> original) {
        return REPLACEMENTS.getOrDefault(original, original);
    }
}

