/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class ModelHelper {
    private static void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    public static BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        builder.setQuadTint(tintIndex);
        ModelHelper.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f);
        ModelHelper.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    public static BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, boolean invert) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        if (invert) {
            normal = normal.func_216371_e();
        }
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        builder.setQuadTint(tintIndex);
        if (invert) {
            ModelHelper.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f);
        } else {
            ModelHelper.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f);
        }
        return builder.build();
    }

    public static BakedQuad createQuadInverted(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        return ModelHelper.createQuadInverted(v1, v2, v3, v4, sprite, ulow, uhigh, vlow, vhigh, tintIndex, false);
    }

    public static BakedQuad createQuadInverted(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, boolean invert) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        if (invert) {
            normal = normal.func_216371_e();
        }
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        builder.setQuadTint(tintIndex);
        if (invert) {
            ModelHelper.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f);
        } else {
            ModelHelper.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ulow, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, uhigh, vlow, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uhigh, vhigh, sprite, 1.0f, 1.0f, 1.0f);
            ModelHelper.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, ulow, vhigh, sprite, 1.0f, 1.0f, 1.0f);
        }
        return builder.build();
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex) {
        return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, texture, tintIndex, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = ModelHelper.v(xl, yh, zl);
        Vector3d SWU = ModelHelper.v(xl, yh, zh);
        Vector3d NWD = ModelHelper.v(xl, yl, zl);
        Vector3d SWD = ModelHelper.v(xl, yl, zh);
        Vector3d NEU = ModelHelper.v(xh, yh, zl);
        Vector3d SEU = ModelHelper.v(xh, yh, zh);
        Vector3d NED = ModelHelper.v(xh, yl, zl);
        Vector3d SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if (up) {
            quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, texture, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
        }
        if (down) {
            quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, texture, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
        }
        if (west) {
            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (east) {
            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (north) {
            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        if (south) {
            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, IBakedModel model, IModelData extraData, Random rand, int tintIndex, int rotation) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, mimic, model, extraData, rand, tintIndex, true, true, true, true, true, true, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, IBakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int rotation) {
        List<TextureAtlasSprite> textureList;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = ModelHelper.v(xl, yh, zl);
        Vector3d SWU = ModelHelper.v(xl, yh, zh);
        Vector3d NWD = ModelHelper.v(xl, yl, zl);
        Vector3d SWD = ModelHelper.v(xl, yl, zh);
        Vector3d NEU = ModelHelper.v(xh, yh, zl);
        Vector3d SEU = ModelHelper.v(xh, yh, zh);
        Vector3d NED = ModelHelper.v(xh, yl, zl);
        Vector3d SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if ((textureList = TextureHelper.getTextureFromModel(model, extraData, rand)).size() == 0) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
            }
            return quads;
        }
        TextureAtlasSprite textureNorth = textureList.get(0);
        TextureAtlasSprite textureEast = textureList.get(0);
        TextureAtlasSprite textureSouth = textureList.get(0);
        TextureAtlasSprite textureWest = textureList.get(0);
        TextureAtlasSprite textureUp = textureList.get(0);
        TextureAtlasSprite textureDown = textureList.get(0);
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.NORTH, rand, extraData)) {
            textureNorth = quad.func_187508_a();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.EAST, rand, extraData)) {
            textureEast = quad.func_187508_a();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.SOUTH, rand, extraData)) {
            textureSouth = quad.func_187508_a();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.WEST, rand, extraData)) {
            textureWest = quad.func_187508_a();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.UP, rand, extraData)) {
            textureUp = quad.func_187508_a();
        }
        for (BakedQuad quad : model.getQuads((BlockState)extraData.getData(FrameBlockTile.MIMIC), Direction.DOWN, rand, extraData)) {
            textureDown = quad.func_187508_a();
        }
        if (rotation == 0) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, SED, SWD, NWD, textureDown, 16.0f - xl * 16.0f, 16.0f - xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, textureWest, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, textureEast, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 1) {
            if (up) {
                quads.add(ModelHelper.createQuadInverted(NWU, NEU, SEU, SWU, textureUp, xl * 16.0f, xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuadInverted(NED, NWD, SWD, SED, textureDown, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureWest, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureEast, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureSouth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureNorth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 2) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureUp, xh * 16.0f, xl * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureDown, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureSouth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureNorth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureEast, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 3) {
            if (up) {
                quads.add(ModelHelper.createQuadInverted(NWU, NEU, SEU, SWU, textureUp, xh * 16.0f, xl * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuadInverted(NED, NWD, SWD, SED, textureDown, xh * 16.0f, xl * 16.0f, 16.0f - zl * 16.0f, 16.0f - zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureEast, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureWest, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureNorth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureSouth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 4) {
            if (up) {
                quads.add(ModelHelper.createQuadInverted(NWU, NEU, SEU, SWU, textureEast, zh * 16.0f, zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuadInverted(NED, NWD, SWD, SED, textureWest, xh * 16.0f, xl * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuadInverted(SWU, SWD, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuadInverted(NEU, NED, SED, SEU, textureSouth, xh * 16.0f, xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuadInverted(NWU, NWD, NED, NEU, textureUp, zh * 16.0f, zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureDown, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 5) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureSouth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureNorth, xh * 16.0f, xl * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureUp, xh * 16.0f, xl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureDown, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuadInverted(NWU, NWD, NED, NEU, textureWest, zh * 16.0f, zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuadInverted(SEU, SED, SWD, SWU, textureEast, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 6) {
            if (up) {
                quads.add(ModelHelper.createQuadInverted(NWU, NEU, SEU, SWU, textureWest, zl * 16.0f, zh * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuadInverted(NED, NWD, SWD, SED, textureEast, xl * 16.0f, xh * 16.0f, zh * 16.0f, zl * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuadInverted(SWU, SWD, NWD, NWU, textureNorth, xh * 16.0f, xl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuadInverted(NEU, NED, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuadInverted(NWU, NWD, NED, NEU, textureDown, zh * 16.0f, zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuadInverted(SEU, SED, SWD, SWU, textureUp, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
        }
        if (rotation == 7) {
            if (up) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureNorth, zh * 16.0f, zl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureSouth, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureDown, xh * 16.0f, xl * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureUp, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(ModelHelper.createQuadInverted(NWU, NWD, NED, NEU, textureWest, zl * 16.0f, zh * 16.0f, yh * 16.0f, yl * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(ModelHelper.createQuadInverted(SEU, SED, SWD, SWU, textureEast, zh * 16.0f, zl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, int tintIndex, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, int rotation) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, tintIndex, true, true, true, true, true, true, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, true, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, Boolean moveOverlay, int rotation) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = ModelHelper.v(xl, yh, zl);
        Vector3d NEU = ModelHelper.v(xl, yh, zh);
        Vector3d NWD = ModelHelper.v(xl, yl, zl);
        Vector3d NED = ModelHelper.v(xl, yl, zh);
        Vector3d SWU = ModelHelper.v(xh, yh, zl);
        Vector3d SEU = ModelHelper.v(xh, yh, zh);
        Vector3d SWD = ModelHelper.v(xh, yl, zl);
        Vector3d SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        if (rotation == 0) {
            if (up && textureUp != null) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down && textureDown != null) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureDown, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (west && textureWest != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureWest, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east && textureEast != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureEast, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureNorth, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureSouth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (west && textureWest != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureWest, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (east && textureEast != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureEast, xl * 16.0f, xh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureNorth, zl * 16.0f, zh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureSouth, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
        }
        if (rotation == 1) {
            if (up && textureUp != null) {
                quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, textureUp, xl * 16.0f, xh * 16.0f, zl * 16.0f, zh * 16.0f, tintIndex));
            }
            if (down && textureDown != null) {
                quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, textureDown, xl * 16.0f, xh * 16.0f, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (east && textureEast != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureEast, zl * 16.0f, zh * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (west && textureWest != null && !moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, 16.0f - yh * 16.0f, 16.0f - yl * 16.0f, tintIndex));
            }
            if (north && textureNorth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, textureNorth, 16.0f - xh * 16.0f, 16.0f - xl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (south && textureSouth != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, textureSouth, xl * 16.0f, xh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (east && textureEast != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, textureEast, zl * 16.0f, zh * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
            if (west && textureWest != null && moveOverlay.booleanValue()) {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, textureWest, 16.0f - zh * 16.0f, 16.0f - zl * 16.0f, yl * 16.0f, yh * 16.0f, tintIndex));
            }
        }
        return quads;
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, texture, tintIndex, true, true, true, true, true, true, ulow, uhigh, vlow, vhigh);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        if (ulow.length != 6 || uhigh.length != 6 || vlow.length != 6 || vhigh.length != 6) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = ModelHelper.v(xl, yh, zl);
        Vector3d NEU = ModelHelper.v(xl, yh, zh);
        Vector3d NWD = ModelHelper.v(xl, yl, zl);
        Vector3d NED = ModelHelper.v(xl, yl, zh);
        Vector3d SWU = ModelHelper.v(xh, yh, zl);
        Vector3d SEU = ModelHelper.v(xh, yh, zh);
        Vector3d SWD = ModelHelper.v(xh, yl, zl);
        Vector3d SED = ModelHelper.v(xh, yl, zh);
        if (up) {
            quads.add(ModelHelper.createQuad(NWU, NEU, SEU, SWU, texture, ulow[0], uhigh[0], vlow[0], vhigh[0], tintIndex));
        }
        if (down) {
            quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, texture, ulow[1], uhigh[1], vlow[1], vhigh[1], tintIndex));
        }
        if (north) {
            quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, texture, ulow[2], uhigh[2], vlow[2], vhigh[2], tintIndex));
        }
        if (east) {
            quads.add(ModelHelper.createQuad(NEU, NED, SED, SEU, texture, ulow[3], uhigh[3], vlow[3], vhigh[3], tintIndex));
        }
        if (south) {
            quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, texture, ulow[4], uhigh[4], vlow[4], vhigh[4], tintIndex));
        }
        if (west) {
            quads.add(ModelHelper.createQuad(SWU, SWD, NWD, NWU, texture, ulow[5], uhigh[5], vlow[5], vhigh[5], tintIndex));
        }
        return quads;
    }

    private static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex) {
        return ModelHelper.createOverlay(xl, xh, yl, yh, zl, zh, overlayIndex, true, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        int tintIndex = -1;
        TextureAtlasSprite overlay = null;
        TextureAtlasSprite upOverlay = null;
        TextureAtlasSprite downOverlay = null;
        if (overlayIndex == 1) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/grass_block_side_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 2) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/grass_block_side_overlay_large"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 3) {
            tintIndex = -1;
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 4) {
            tintIndex = -1;
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay_small"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 5) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/vine"));
        }
        if (overlayIndex >= 6 && overlayIndex <= 10) {
            tintIndex = -1;
            doNotMoveOverlay = false;
            if (overlayIndex == 6) {
                overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
            }
            if (overlayIndex == 7) {
                overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
            }
            if (overlayIndex == 8) {
                overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chiseled_sandstone_overlay"));
            }
            if (overlayIndex == 9) {
                overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
            }
            if (overlayIndex == 10) {
                overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
            }
        }
        if (overlayIndex == 11) {
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/crimson_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/crimson_nylium"));
        }
        if (overlayIndex == 12) {
            overlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/warped_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/warped_nylium"));
        }
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, tintIndex, north, south, east, west, up, down, overlay, overlay, overlay, overlay, upOverlay, downOverlay, doNotMoveOverlay, 0);
    }

    public static List<BakedQuad> createSlope(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, Direction direction) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = ModelHelper.v(xl, yh, zl);
        Vector3d NEU = ModelHelper.v(xl, yh, zh);
        Vector3d NWD = ModelHelper.v(xl, yl, zl);
        Vector3d NED = ModelHelper.v(xl, yl, zh);
        Vector3d SWU = ModelHelper.v(xh, yh, zl);
        Vector3d SEU = ModelHelper.v(xh, yh, zh);
        Vector3d SWD = ModelHelper.v(xh, yl, zl);
        Vector3d SED = ModelHelper.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_error"), true);
            }
            return quads;
        }
        if (xl < 0.0f) {
            xl += 1.0f;
            xh += 1.0f;
        }
        if (xh > 1.0f) {
            xh -= 1.0f;
            xl -= 1.0f;
        }
        if (yl < 0.0f) {
            yl += 1.0f;
            yh += 1.0f;
        }
        if (yh > 1.0f) {
            yh -= 1.0f;
            yl -= 1.0f;
        }
        if (zl < 0.0f) {
            zl += 1.0f;
            zh += 1.0f;
        }
        if (zh > 1.0f) {
            zh -= 1.0f;
            zl -= 1.0f;
        }
        quads.add(ModelHelper.createQuad(NED, NWD, SWD, SED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
        switch (direction) {
            case NORTH: {
                quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                break;
            }
            case WEST: {
                quads.add(ModelHelper.createQuad(NWU, NWD, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(SWD, SWD, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(NEU, NED, NED, SED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                break;
            }
            case SOUTH: {
                quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                break;
            }
            case EAST: {
                quads.add(ModelHelper.createQuad(SEU, SED, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(SWD, SWU, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(SED, NEU, NEU, NED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
            }
        }
        quads.add(ModelHelper.createQuad(SWU, SEU, NEU, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
        return quads;
    }
}

