/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaneFrameBlock
extends PaneBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;

    public PaneFrameBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_196409_a, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196411_b, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196413_c, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196414_y, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_204514_u, (Comparable)Boolean.FALSE)).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONTAINS_BLOCK, LIGHT_LEVEL, field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FrameBlockTile();
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
            BlockAppearanceHelper.setGlassColor(world, pos, player, hand);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof FrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                    this.checkForVisibility(state, world, pos, (FrameBlockTile)tileEntity);
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        FrameBlockTile frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof FrameBlockTile && (blockState = (frameTileEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.clear();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.clear();
        }
    }

    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameTileEntity = (FrameBlockTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
        if (((Boolean)state.func_177229_b((Property)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a((Property)field_196415_z.get(facing), (Comparable)Boolean.valueOf(this.func_220112_a(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d())))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)field_204514_u) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(@Nonnull BlockState state, BlockState adjacentBlockState, @Nonnull Direction side) {
        return adjacentBlockState.func_203425_a((Block)this) || super.func_200122_a(state, adjacentBlockState, side);
    }

    private void checkForVisibility(BlockState state, World world, BlockPos pos, FrameBlockTile tileEntity) {
        if (world.field_72995_K) {
            for (Direction d : Direction.values()) {
                BlockPos.Mutable mutablePos = pos.func_239590_i_();
                BlockState adjacentBlockState = world.func_180495_p((BlockPos)mutablePos.func_189536_c(d));
                tileEntity.setVisibileSides(d, !adjacentBlockState.func_200132_m() && !this.func_200122_a(state, adjacentBlockState, d));
            }
        }
    }
}

