/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.AbstractFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockState;

public class FrameBlock
extends AbstractFrameBlock
implements IForgeBlockState,
IWaterLoggable {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    private static final VoxelShape MIDDLE_STRIP_NORTH = Block.func_208617_a((double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)9.0, (double)2.0);
    private static final VoxelShape MIDDLE_STRIP_EAST = Block.func_208617_a((double)14.0, (double)8.0, (double)2.0, (double)15.0, (double)9.0, (double)14.0);
    private static final VoxelShape MIDDLE_STRIP_SOUTH = Block.func_208617_a((double)0.0, (double)8.0, (double)14.0, (double)16.0, (double)9.0, (double)15.0);
    private static final VoxelShape MIDDLE_STRIP_WEST = Block.func_208617_a((double)1.0, (double)8.0, (double)2.0, (double)2.0, (double)9.0, (double)14.0);
    private static final VoxelShape TOP = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape NW_PILLAR = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0);
    private static final VoxelShape SW_PILLAR = Block.func_208617_a((double)0.0, (double)1.0, (double)14.0, (double)2.0, (double)15.0, (double)16.0);
    private static final VoxelShape NE_PILLAR = Block.func_208617_a((double)14.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0);
    private static final VoxelShape SE_PILLAR = Block.func_208617_a((double)14.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape MID = Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape CUBE = VoxelShapes.func_216384_a((VoxelShape)MIDDLE_STRIP_EAST, (VoxelShape[])new VoxelShape[]{MIDDLE_STRIP_SOUTH, MIDDLE_STRIP_WEST, MIDDLE_STRIP_NORTH, TOP, DOWN, NW_PILLAR, SW_PILLAR, NE_PILLAR, SE_PILLAR, MID});

    public FrameBlock(AbstractBlock.Properties properties) {
        super(properties.func_208770_d());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FrameBlockTile();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof FrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                    this.checkForVisibility(state, world, pos, (FrameBlockTile)tileEntity);
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        FrameBlockTile frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof FrameBlockTile && (blockState = (frameTileEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.clear();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.clear();
        }
    }

    @Override
    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameTileEntity = (FrameBlockTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
    }

    public int setLightValue(BlockState state, int amount) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        if (fluidstate.func_206886_c() == Fluids.field_204546_a) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206889_d()));
        }
        return this.func_176223_P();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
            return CUBE;
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_203425_a((Block)this) || super.func_200122_a(state, adjacentBlockState, side);
    }

    private void checkForVisibility(BlockState state, World world, BlockPos pos, FrameBlockTile tileEntity) {
        if (world.field_72995_K) {
            for (Direction d : Direction.values()) {
                BlockPos.Mutable mutablePos = pos.func_239590_i_();
                BlockState adjacentBlockState = world.func_180495_p((BlockPos)mutablePos.func_189536_c(d));
                tileEntity.setVisibileSides(d, !adjacentBlockState.func_200132_m() && !this.func_200122_a(state, adjacentBlockState, d));
            }
        }
    }
}

