/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionCarpetBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        ModelResourceLocation location;
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null && (model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location)) != null) {
            TextureAtlasSprite glass = TextureHelper.getGlassTextures().get((Integer)extraData.getData(FrameBlockTile.GLASS_COLOR));
            int woolInt = (Integer)extraData.getData(FrameBlockTile.GLASS_COLOR) - 1;
            if (woolInt < 0) {
                woolInt = 0;
            }
            TextureAtlasSprite wool = TextureHelper.getWoolTextures().get(woolInt);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            boolean renderNorth = (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE);
            boolean renderEast = (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE);
            boolean renderSouth = (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE);
            boolean renderWest = (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE);
            int rotation = (Integer)extraData.getData(FrameBlockTile.ROTATION);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 0) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
            } else if (design == 1) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 0.0625f, 0.0f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 0.0625f, 0.0625f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.9375f, 0.0f, 0.0625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, glass, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
            } else if (design == 2) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.0f, 0.0625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.0f, 0.0625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.0f, 0.0625f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.0625f, 0.125f, 0.875f, glass, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
            } else if (design == 3) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 0.0625f, 0.0f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 0.0625f, 0.0625f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.9375f, 0.0f, 0.0625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, wool, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
            } else if (design == 4) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.0f, 0.0625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.0f, 0.0625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.0f, 0.0625f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.0625f, 0.125f, 0.875f, wool, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, overlayIndex, true, true, true, true, true, true, false));
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

