/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.DaylightDetectorFrameBlock;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.DaylightDetectorFrameTileEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class DaylightDetectorBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(DaylightDetectorFrameTileEntity.MIMIC);
        Integer design = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.DESIGN);
        Integer desTex = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.DESIGN_TEXTURE);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock)) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)mimic);
            if (state != null) {
                IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
                List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
                TextureAtlasSprite sensor_side = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/daylight_detector_side"));
                TextureAtlasSprite glass = TextureHelper.getGlassTextures().get((Integer)extraData.getData(DaylightDetectorFrameTileEntity.GLASS_COLOR));
                TextureAtlasSprite sensor = (Boolean)state.func_177229_b((Property)DaylightDetectorFrameBlock.field_196320_b) != false ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/daylight_detector_inverted_top")) : (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/daylight_detector_top"));
                Integer tex = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.TEXTURE);
                if (textureList.size() <= tex) {
                    extraData.setData(DaylightDetectorFrameTileEntity.TEXTURE, (Object)0);
                    tex = 0;
                }
                if (textureList.size() == 0) {
                    if (Minecraft.func_71410_x().field_71439_g != null) {
                        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                    }
                    for (int i = 0; i < 6; ++i) {
                        textureList.add((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missing")));
                    }
                }
                TextureAtlasSprite texture = textureList.get(tex);
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                if (design == 0) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, true, true));
                } else if (design == 1) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.375f, 0.0625f, 0.9375f, tintIndex, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                } else if (design == 2) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.0625f, 0.9375f, tintIndex, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                } else if (design == 3) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.25f, 0.0625f, 0.9375f, tintIndex, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.25f, 0.375f, 0.0625f, 0.9375f, glass, -1));
                } else if (design == 4) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.3125f, 0.0625f, 0.9375f, tintIndex, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.375f, 0.3125f, 0.375f, 0.0625f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.625f, 0.6875f, 0.3125f, 0.375f, 0.0625f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.375f, 0.3125f, 0.375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.375f, 0.625f, 0.6875f, texture, tintIndex));
                }
                int overlayIndex = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.OVERLAY);
                if (overlayIndex != 0) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, overlayIndex, true, true, true, true, true, true, false));
                }
                return quads;
            }
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

