/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ButtonBakedModel
implements IDynamicBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null && (model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location)) != null) {
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null && state != null) {
            TextureAtlasSprite texture;
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            if (textureList.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                }
                texture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missing"));
            } else {
                texture = textureList.get(tex);
            }
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            float yl = 0.0f;
            float yh = 0.125f;
            if (((AttachFace)state.func_177229_b((Property)WoodButtonBlock.field_196366_M)).equals((Object)AttachFace.CEILING)) {
                yl = 0.875f;
                yh = 1.0f;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            block0 : switch ((AttachFace)state.func_177229_b((Property)WoodButtonBlock.field_196366_M)) {
                case WALL: {
                    switch ((Direction)state.func_177229_b((Property)WoodButtonBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 0.875f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.375f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, 0.125f, texture, tintIndex));
                        }
                    }
                    break;
                }
                case FLOOR: 
                case CEILING: {
                    switch ((Direction)state.func_177229_b((Property)WoodButtonBlock.field_185512_D)) {
                        case EAST: 
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, texture, tintIndex));
                            break block0;
                        }
                        case NORTH: 
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, texture, tintIndex));
                        }
                    }
                }
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                block14 : switch ((AttachFace)state.func_177229_b((Property)WoodButtonBlock.field_196366_M)) {
                    case WALL: {
                        switch ((Direction)state.func_177229_b((Property)WoodButtonBlock.field_185512_D)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 0.875f, 1.0f, overlayIndex));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.125f, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.875f, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, 0.125f, overlayIndex));
                            }
                        }
                        break;
                    }
                    case FLOOR: 
                    case CEILING: {
                        switch ((Direction)state.func_177229_b((Property)WoodButtonBlock.field_185512_D)) {
                            case EAST: 
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, overlayIndex));
                                break block14;
                            }
                            case NORTH: 
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, overlayIndex));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

