/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.ftb.mods.ftbchunks.data.HeightUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class TeleportFromMapPacket
extends BaseC2SMessage {
    public final int x;
    public final int y;
    public final int z;
    public final boolean unknownY;
    public final RegistryKey<World> dimension;

    public TeleportFromMapPacket(int _x, int _y, int _z, boolean uy, RegistryKey<World> d) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.unknownY = uy;
        this.dimension = d;
    }

    TeleportFromMapPacket(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.unknownY = buf.readBoolean();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
    }

    public MessageType getType() {
        return FTBChunksNet.TELEPORT_FROM_MAP;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.unknownY);
        buf.func_192572_a(this.dimension.func_240901_a_());
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayerEntity p = (ServerPlayerEntity)context.getPlayer();
        ServerWorld level = p.func_184102_h().func_71218_a(this.dimension);
        if (level != null && p.func_211513_k(2)) {
            int y1 = this.y;
            if (this.unknownY) {
                IChunk chunkAccess = level.func_217353_a(this.x >> 4, this.z >> 4, ChunkStatus.field_222617_m, true);
                if (chunkAccess == null) {
                    return;
                }
                int topY = chunkAccess.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.x, this.z);
                if (topY == -1) {
                    return;
                }
                BlockPos.Mutable blockPos = new BlockPos.Mutable(this.x, topY, this.z);
                int[] water = new int[]{-32767};
                y1 = HeightUtils.getHeight((World)level, chunkAccess, blockPos, water).func_177956_o();
                if (y1 == -32767) {
                    y1 = 70;
                }
                if (water[0] != -32767) {
                    y1 = Math.max(y1, water[0]);
                }
            }
            p.func_200619_a(level, (double)this.x + 0.5, (double)y1 + 2.1, (double)this.z + 0.5, p.field_70177_z, p.field_70125_A);
        }
    }
}

