/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class IndustrialWorkingTile<T extends IndustrialWorkingTile<T>>
extends IndustrialMachineTile<T> {
    @Save
    private ProgressBarComponent<T> workingBar;

    public IndustrialWorkingTile(BasicTileBlock<T> basicTileBlock, final int estimatedPower) {
        super(basicTileBlock);
        this.workingBar = new ProgressBarComponent<T>(30, 20, this.getMaxProgress(), this.getMaxProgress()){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, IndustrialWorkingTile.this.workingBar){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(IndustrialWorkingTile.this.workingBar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(IndustrialWorkingTile.this.workingBar.getMaxProgress())));
                        int progress = IndustrialWorkingTile.this.workingBar.getMaxProgress() - IndustrialWorkingTile.this.workingBar.getProgress();
                        if (!IndustrialWorkingTile.this.workingBar.getIncreaseType()) {
                            progress = IndustrialWorkingTile.this.workingBar.getMaxProgress() - progress;
                        }
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * IndustrialWorkingTile.this.workingBar.getTickingTime()) / 20.0 / (double)IndustrialWorkingTile.this.workingBar.getProgressIncrease())) + TextFormatting.DARK_AQUA + "s"));
                        if (estimatedPower > 0) {
                            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.usage").getString() + TextFormatting.WHITE + estimatedPower + TextFormatting.DARK_AQUA + " FE"));
                        }
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this.getSelf()).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setIncreaseType(false).setOnFinishWork(() -> {
            if (this.isServer()) {
                WorkAction work = this.work();
                this.getEnergyStorage().extractEnergy(work.getEnergyConsumed(), false);
                int operations = (int)(this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(ProcessingAddonItem.PROCESSING).get(0)), (IAugmentType)ProcessingAddonItem.PROCESSING) - 1.0f : 0.0f);
                for (int i = 0; i < operations; ++i) {
                    work = this.work();
                    this.getEnergyStorage().extractEnergy(work.getEnergyConsumed(), false);
                }
                int maxProgress = (int)Math.floor((float)this.getMaxProgress() * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
                this.workingBar.setMaxProgress(maxProgress);
                this.workingBar.setProgress((int)((float)maxProgress * work.getWorkAmount()));
                this.getRedstoneManager().finish();
            }
        }).setOnTickWork(() -> this.workingBar.setProgressIncrease(this.hasAugmentInstalled(AugmentTypes.SPEED) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.SPEED).get(0)), (IAugmentType)AugmentTypes.SPEED) : 1)).setCanReset(tileEntity -> true).setCanIncrease(tileEntity -> ((RedstoneAction)this.getRedstoneManager().getAction()).canRun(tileEntity.getEnvironmentValue(false, null)) && this.getRedstoneManager().shouldWork()).setColor(DyeColor.LIME);
        this.addProgressBar(this.workingBar);
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.PASS;
    }

    public abstract WorkAction work();

    public boolean hasEnergy(int amount) {
        return this.getEnergyStorage().getEnergyStored() >= amount;
    }

    public int getMaxProgress() {
        return 100;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)ProcessingAddonItem.PROCESSING)) {
            return !this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING);
        }
        return super.canAcceptAugment(augment);
    }

    public class WorkAction {
        private final float workAmount;
        private final int energyConsumed;

        public WorkAction(float workAmount, int energyConsumed) {
            this.workAmount = workAmount;
            this.energyConsumed = energyConsumed;
        }

        public float getWorkAmount() {
            return this.workAmount;
        }

        public int getEnergyConsumed() {
            return this.energyConsumed;
        }
    }
}

