/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.core.init.CoreKeys;
import cofh.lib.item.ContainerType;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.KeyHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeItem;

public interface ICoFHItem
extends IForgeItem {
    default public boolean isCreative(ItemStack stack, ContainerType type) {
        switch (type) {
            case ITEM: {
                return AugmentableHelper.getPropertyWithDefault(stack, "ItemCre", 0.0f) > 0.0f;
            }
            case FLUID: {
                return AugmentableHelper.getPropertyWithDefault(stack, "FluidCre", 0.0f) > 0.0f;
            }
            case ENERGY: {
                return AugmentableHelper.getPropertyWithDefault(stack, "RFCre", 0.0f) > 0.0f;
            }
        }
        return false;
    }

    default public boolean canPlayerAccess(ItemStack stack, PlayerEntity player) {
        return SecurityHelper.getAccess(stack).matches(SecurityHelper.getOwner(stack), (Entity)player);
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.hasSecurity(stack);
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            location.func_184224_h(true);
            ((ItemEntity)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    default public void addEnergyTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, int extract, int receive, boolean creative) {
        if (extract == receive && extract > 0 || creative) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.transfer") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
        } else if (extract > 0) {
            if (receive > 0) {
                tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + "|" + StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(extract) + "|" + StringHelper.getScaledNumber(receive) + " RF/t"));
            } else {
                tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
            }
        } else if (receive > 0) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(receive) + " RF/t"));
        }
    }

    default public void addIncrementModeChangeTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.mode_change", new Object[]{KeyHelper.getKeynameFromKeycode(CoreKeys.MULTIMODE_INCREMENT.getKey().func_197937_c())}).func_240699_a_(TextFormatting.YELLOW));
    }

    default public boolean isActive(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("Active");
    }

    default public void setActive(ItemStack stack, boolean state) {
        stack.func_196082_o().func_74757_a("Active", state);
    }

    default public boolean hasActiveTag(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("Active");
    }

    default public void setActive(ItemStack stack, LivingEntity entity) {
        stack.func_196082_o().func_74772_a("Active", entity.field_70170_p.func_82737_E() + 20L);
    }
}

