/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.control.IRedstoneControllable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected int threshold;
    protected byte mode;

    public RedstoneControlPacket() {
        super(34, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof IRedstoneControllableTile) {
            ((IRedstoneControllableTile)tile).setControl(this.threshold, IRedstoneControllable.ControlMode.VALUES[this.mode]);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.threshold);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.threshold = buf.readInt();
        this.mode = buf.readByte();
    }

    public static void sendToServer(IRedstoneControllableTile tile) {
        RedstoneControlPacket packet = new RedstoneControlPacket();
        packet.pos = tile.pos();
        packet.threshold = tile.redstoneControl().getThreshold();
        packet.mode = (byte)tile.redstoneControl().getMode().ordinal();
        packet.sendToServer();
    }
}

