/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import me.tepis.integratednbt.ExtendedContainerScreen;
import me.tepis.integratednbt.HoverTextImageButton;
import me.tepis.integratednbt.NBTExtractorContainer;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTTreeViewer;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import me.tepis.integratednbt.network.PacketHandler;
import me.tepis.integratednbt.network.clientbound.NBTExtractorUpdateClientMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateAutoRefreshMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateExtractionPathMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateOutputModeMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class NBTExtractorScreen
extends ExtendedContainerScreen<NBTExtractorContainer> {
    public static final int SCREEN_EDGE = 4;
    public static final Texture GUI_TEXTURE = new Texture("integratednbt", "textures/gui/nbt_extractor.png");
    private static final TexturePart PART0 = GUI_TEXTURE.createPart(0, 0, 8, 24);
    private static final TexturePart PART1 = GUI_TEXTURE.createPart(12, 0, 4, 24);
    private static final TexturePart PART2 = GUI_TEXTURE.createPart(20, 0, 8, 24);
    private static final TexturePart PART3 = GUI_TEXTURE.createPart(0, 28, 8, 4);
    private static final TexturePart PART4 = GUI_TEXTURE.createPart(12, 28, 4, 4);
    private static final TexturePart PART5 = GUI_TEXTURE.createPart(20, 28, 8, 4);
    private static final TexturePart PART6 = GUI_TEXTURE.createPart(0, 36, 8, 8);
    private static final TexturePart PART7 = GUI_TEXTURE.createPart(12, 36, 4, 8);
    private static final TexturePart PART8 = GUI_TEXTURE.createPart(20, 36, 178, 110);
    private static final TexturePart PART9 = GUI_TEXTURE.createPart(202, 36, 8, 8);
    private static final int BUTTON_SIZE = 12;
    private static final TexturePart BUTTON_UNKNOWN = GUI_TEXTURE.createPart(78, 0, 12, 12);
    private static final TexturePart BUTTON_UNKNOWN_HOVER = GUI_TEXTURE.createPart(78, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON = GUI_TEXTURE.createPart(126, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON_HOVER = GUI_TEXTURE.createPart(126, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF = GUI_TEXTURE.createPart(138, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF_HOVER = GUI_TEXTURE.createPart(138, 12, 12, 12);
    private static final int BASE_PADDING = 200;
    private static final int INVENTORY_WIDTH = 178;
    private static final int INVENTORY_HEIGHT = 110;
    private static final int TOP_BORDER_SIZE = 24;
    private static final int SIDE_BORDER_SIZE = 8;
    private static final double CENTERED_TEXT_MAX_RATIO = 0.8;
    private static final int BUTTON_SPACING = 2;
    private static NBTExtractorScreen lastInstance = null;
    private static NBTExtractorUpdateClientMessage.ErrorCode errorCode = null;
    private static INBT nbt;
    private static NBTPath extractionPath;
    private static NBTExtractorOutputMode outputMode;
    private static ITextComponent errorMessage;
    private static Boolean autoRefresh;
    private NBTTreeViewer treeViewer;
    private NBTExtractorContainer nbtExtractorContainer;
    private FontRenderer fontRenderer;
    private int padding;
    private int screenWidth;
    private int screenHeight;
    private double scaleFactor;
    private HoverTextImageButton outputModeButton;
    private HoverTextImageButton autoRefreshButton;

    public NBTExtractorScreen(NBTExtractorContainer screenContainer, PlayerInventory inventory, ITextComponent title) {
        super(screenContainer, inventory, title);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        lastInstance = this;
        this.nbtExtractorContainer = screenContainer;
        NBTExtractorTileEntity tileEntity = this.nbtExtractorContainer.getNbtExtractorEntity();
        this.treeViewer = new NBTTreeViewer(this, tileEntity.getExpandedPaths(), tileEntity.getScrollTop()){

            @Override
            public void onUpdateSelectedPath(NBTPath newPath, INBT nbt) {
                PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateExtractionPathMessage(NBTExtractorScreen.this.nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), newPath, nbt.func_74732_a()));
            }

            @Override
            public NBTPath getSelectedPath() {
                return extractionPath;
            }
        };
    }

    public static void updateError(NBTExtractorUpdateClientMessage.ErrorCode errorCode) {
        NBTExtractorScreen.errorCode = errorCode;
    }

    public static void updateNBT(INBT nbt) {
        NBTExtractorScreen.nbt = nbt;
    }

    public static void updateExtractionPath(NBTPath extractionPath) {
        NBTExtractorScreen.extractionPath = extractionPath;
    }

    public static void updateOutputMode(NBTExtractorOutputMode outputMode) {
        NBTExtractorScreen.outputMode = outputMode;
        if (lastInstance != null) {
            lastInstance.updateOutputModeButton();
        }
    }

    private void updateOutputModeButton() {
        if (this.outputModeButton == null) {
            return;
        }
        ArrayList<ITextComponent> messages = new ArrayList<ITextComponent>();
        if (outputMode == null) {
            this.outputModeButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor.output_mode", new Object[]{new TranslationTextComponent("integratednbt:nbt_extractor.loading")}));
        } else {
            this.outputModeButton.setTexture(outputMode.getButtonTextureNormal(), outputMode.getButtonTextureHover());
            messages.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor.output_mode", new Object[]{outputMode.getName()}));
        }
        messages.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor.output_mode.description.begin").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        messages.add((ITextComponent)new StringTextComponent(""));
        Arrays.stream(NBTExtractorOutputMode.values()).forEach(describingOutputMode -> messages.add(describingOutputMode.getDescription(describingOutputMode.equals((Object)outputMode))));
        messages.add((ITextComponent)new StringTextComponent(""));
        messages.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor.output_mode.description.end", new Object[]{NBTExtractorOutputMode.REFERENCE.getName()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        this.outputModeButton.setHoverText(messages);
    }

    public static void updateErrorMessage(ITextComponent errorMessage) {
        NBTExtractorScreen.errorMessage = errorMessage;
    }

    public static void updateAutoRefresh(Boolean autoRefresh) {
        NBTExtractorScreen.autoRefresh = autoRefresh;
        if (lastInstance != null) {
            lastInstance.updateAutoRefreshButton();
        }
    }

    private void updateAutoRefreshButton() {
        if (this.autoRefreshButton == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (autoRefresh == null) {
            this.autoRefreshButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0])}));
        } else if (autoRefresh.booleanValue()) {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_ON, BUTTON_REFRESH_ON_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.on", (Object[])new Object[0])}));
        } else {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_OFF, BUTTON_REFRESH_OFF_HOVER);
            messages.add(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.off", (Object[])new Object[0])}));
        }
        messages.addAll(Arrays.asList(I18n.func_135052_a((String)"integratednbt:nbt_extractor.auto_refresh.description", (Object[])new Object[0]).split("\\\\n")));
        this.autoRefreshButton.setHoverTextRaw(messages);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        this.treeViewer.mouseClicked(mouseButton);
        return true;
    }

    protected void func_231160_c_() {
        this.updateCalculations();
        this.field_146999_f = this.field_230708_k_ - 2 * this.padding;
        this.field_147000_g = this.field_230709_l_ - 2 * this.padding;
        super.func_231160_c_();
        this.nbtExtractorContainer.setSlotOffset((this.field_146999_f - 178) / 2, this.field_147000_g - 110);
        this.treeViewer.updateBounds(this.padding + 8, this.padding + 24, this.screenWidth, this.screenHeight);
        this.outputModeButton = new HoverTextImageButton((Screen)this, this.field_230708_k_ - this.padding - 7 - 12, this.padding + 7, this::onOutputModeButtonClick);
        this.updateOutputModeButton();
        this.func_230480_a_((Widget)this.outputModeButton);
        this.autoRefreshButton = new HoverTextImageButton((Screen)this, this.field_230708_k_ - this.padding - 7 - 24 - 2, this.padding + 7, this::onAutoRefreshButtonClick);
        this.updateAutoRefreshButton();
        this.func_230480_a_((Widget)this.autoRefreshButton);
    }

    private void updateCalculations() {
        this.scaleFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        this.padding = (int)Math.min(Math.max(200.0 / Math.pow(this.scaleFactor, 3.0), 4.0), (double)Math.min(this.field_230708_k_, this.field_230709_l_) / 10.0);
        this.screenWidth = this.field_230708_k_ - 2 * this.padding - 16;
        this.screenHeight = this.field_230709_l_ - 2 * this.padding - 24 - 110;
    }

    public void onOutputModeButtonClick(Button ignored) {
        if (outputMode == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateOutputModeMessage(this.nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), NBTExtractorOutputMode.values()[(outputMode.ordinal() + 1) % NBTExtractorOutputMode.values().length]));
    }

    public void onAutoRefreshButtonClick(Button ignored) {
        if (autoRefresh == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateAutoRefreshMessage(this.nbtExtractorContainer.getNbtExtractorEntity().func_174877_v(), autoRefresh == false));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dWheel) {
        super.func_231043_a_(mouseX, mouseY, dWheel);
        if (errorCode == NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR && nbt != null) {
            this.treeViewer.mouseScrolled(dWheel);
        }
        return true;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.outputModeButton.drawHover(matrixStack, mouseX, mouseY);
        this.autoRefreshButton.drawHover(matrixStack, mouseX, mouseY);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.renderGuiParts(matrixStack);
        this.fontRenderer.func_238421_b_(matrixStack, I18n.func_135052_a((String)"block.integratednbt.nbt_extractor", (Object[])new Object[0]), (float)(this.padding + 8), (float)(this.padding + 9), 0x404040);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)this.scaleFactor * (this.padding + 8)), (int)((int)this.scaleFactor * (this.padding + 110)), (int)((int)this.scaleFactor * this.screenWidth), (int)((int)this.scaleFactor * this.screenHeight));
        Slot srcNBTSlot = this.nbtExtractorContainer.getSrcNBTSlot();
        if (!srcNBTSlot.func_75216_d()) {
            errorCode = null;
            this.renderWelcome(matrixStack);
        } else if (errorCode == null) {
            this.renderLoading(matrixStack);
        } else if (!errorCode.equals((Object)NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR)) {
            this.renderError(matrixStack);
        } else {
            this.treeViewer.render(matrixStack, nbt, mouseX, mouseY);
        }
        GL11.glDisable((int)3089);
    }

    public void func_231164_f_() {
        if (lastInstance == this) {
            lastInstance = null;
            errorCode = null;
            nbt = null;
            extractionPath = null;
            outputMode = null;
            errorMessage = null;
        }
        super.func_231164_f_();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void renderGuiParts(MatrixStack matrixStack) {
        int padding = this.padding;
        int screenWidth = this.screenWidth;
        int screenHeight = this.screenHeight;
        GUI_TEXTURE.bind();
        PART0.renderTo((AbstractGui)this, matrixStack, padding, padding);
        PART1.renderTo(this, padding + 8, padding, screenWidth, -1);
        PART2.renderTo((AbstractGui)this, matrixStack, this.field_230708_k_ - padding - 8, padding);
        PART3.renderTo(this, padding, padding + 24, -1, screenHeight);
        PART4.renderTo(this, padding + 8, padding + 24, screenWidth, screenHeight);
        PART5.renderTo(this, this.field_230708_k_ - padding - 8, padding + 24, -1, screenHeight);
        int topOfPart6789 = this.field_230709_l_ - padding - 110;
        PART6.renderTo((AbstractGui)this, matrixStack, padding, topOfPart6789);
        int part7Width2x = this.field_230708_k_ - 2 * padding - 16 - 178;
        int part7WidthFloor = (int)Math.floor((double)part7Width2x / 2.0);
        int part7WidthCeil = (int)Math.ceil((double)part7Width2x / 2.0);
        PART7.renderTo(this, padding + 8, topOfPart6789, part7WidthFloor, -1);
        PART8.renderTo((AbstractGui)this, matrixStack, padding + 8 + part7WidthFloor, topOfPart6789);
        PART7.renderTo(this, padding + 8 + part7WidthFloor + 178, topOfPart6789, part7WidthCeil, -1);
        PART9.renderTo((AbstractGui)this, matrixStack, this.field_230708_k_ - padding - 8, topOfPart6789);
    }

    private void renderWelcome(MatrixStack matrixStack) {
        this.renderCenteredTextGroup(matrixStack, I18n.func_135052_a((String)"integratednbt:nbt_extractor.welcome", (Object[])new Object[0]), 65535, I18n.func_135052_a((String)"integratednbt:nbt_extractor.welcome.description", (Object[])new Object[0]));
    }

    private void renderLoading(MatrixStack matrixStack) {
        this.renderCenteredTextGroup(matrixStack, I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0]), 0xFFFF00, I18n.func_135052_a((String)"integratednbt:nbt_extractor.loading.description", (Object[])new Object[0]));
    }

    private void renderError(MatrixStack matrixStack) {
        String message = "";
        if (errorMessage != null) {
            message = errorMessage.getString();
        } else {
            switch (errorCode) {
                case EVAL_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.eval", (Object[])new Object[0]);
                    break;
                }
                case TYPE_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.type", (Object[])new Object[0]);
                    break;
                }
                case UNEXPECTED_ERROR: {
                    message = I18n.func_135052_a((String)"integratednbt:nbt_extractor.error.unexpected", (Object[])new Object[0]);
                }
            }
        }
        this.renderCenteredTextGroup(matrixStack, I18n.func_135052_a((String)"integratednbt:nbt_extractor.error", (Object[])new Object[0]), 0xFF5555, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCenteredTextGroup(MatrixStack matrixStack, String title, int titleColor, String description) {
        GL11.glPushMatrix();
        try {
            int x = this.screenCenterX();
            int y = this.screenCenterY();
            int titleWidth = this.fontRenderer.func_78256_a(title);
            GL11.glPushMatrix();
            try {
                this.scaleAt(x, y, 2.0);
                float f = (float)(-titleWidth) / 2.0f;
                this.fontRenderer.getClass();
                this.fontRenderer.func_238421_b_(matrixStack, title, f, (float)(-9 - 1), titleColor);
            }
            finally {
                GL11.glPopMatrix();
            }
            this.scaleAt(x, y, 1.0);
            int wrappingWidth = (int)((double)this.screenWidth * 0.8);
            int descriptionWidth = this.fontRenderer.func_78256_a(description);
            if (descriptionWidth > wrappingWidth) {
                this.fontRenderer.func_238418_a_((ITextProperties)new StringTextComponent(description), -wrappingWidth / 2, 4, wrappingWidth, 0xFFFFFF);
            } else {
                this.fontRenderer.func_238421_b_(matrixStack, description, (float)(-descriptionWidth) / 2.0f, 4.0f, 0xFFFFFF);
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private int screenCenterX() {
        return this.field_230708_k_ / 2;
    }

    private int screenCenterY() {
        return this.padding + 24 + this.screenHeight / 2;
    }

    private void scaleAt(int x, int y, double scale) {
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        GL11.glTranslated((double)((double)x / scale), (double)((double)y / scale), (double)0.0);
    }

    static {
        extractionPath = null;
        outputMode = null;
        errorMessage = null;
        autoRefresh = null;
    }
}

