/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum BMLog {
    DEFAULT("bloodmagic"){

        @Override
        boolean enabled() {
            return true;
        }
    }
    ,
    DEBUG{

        @Override
        boolean enabled() {
            return false;
        }
    }
    ,
    API{

        @Override
        boolean enabled() {
            return false;
        }
    }
    ,
    API_VERBOSE{

        @Override
        boolean enabled() {
            return false;
        }
    };

    private final Logger logger;

    private BMLog(String logName) {
        this.logger = LogManager.getLogger((String)logName);
    }

    private BMLog() {
        this.logger = LogManager.getLogger((String)("bloodmagic|" + WordUtils.capitalizeFully((String)this.name().replace("_", " "))));
    }

    abstract boolean enabled();

    public void info(String input, Object ... args) {
        if (this.enabled()) {
            this.logger.info(input, args);
        }
    }

    public void error(String input, Object ... args) {
        if (this.enabled()) {
            this.logger.error(input, args);
        }
    }

    public void warn(String input, Object ... args) {
        if (this.enabled()) {
            this.logger.warn(input, args);
        }
    }
}

