/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ARCProcessor
implements IComponentProcessor {
    private RecipeARC recipe;

    public void setup(IVariableProvider variables) {
        IRecipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(id);
        if (recipeHandler.isPresent() && (recipe = (IRecipe)recipeHandler.get()).func_222127_g().equals(BloodMagicRecipeType.ARC)) {
            this.recipe = (RecipeARC)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Alchemical Reaction Chamber recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        int index;
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("output")) {
            int index2 = Integer.parseInt(key.substring(6)) - 1;
            if (this.recipe.getAllListedOutputs().size() > index2) {
                return IVariable.from((Object)this.recipe.getAllListedOutputs().get(index2));
            }
            return null;
        }
        if (key.startsWith("chance")) {
            index = Integer.parseInt(key.substring(6)) - 2;
            if (this.recipe.getAllOutputChances().length > index) {
                double chance = this.recipe.getAllOutputChances()[index] * 100.0;
                if (chance < 1.0) {
                    return IVariable.wrap((String)"<1");
                }
                return IVariable.wrap((Number)Math.round(chance));
            }
        } else if (key.startsWith("show_chance")) {
            index = Integer.parseInt(key.substring(11)) - 2;
            if (this.recipe.getAllOutputChances().length > index) {
                return IVariable.wrap((Boolean)true);
            }
        }
        switch (key) {
            case "show_fluid_tooltip": {
                if (this.recipe.getFluidIngredient() != null || this.recipe.getFluidOutput() != FluidStack.EMPTY) {
                    return IVariable.wrap((Boolean)true);
                }
                return IVariable.wrap((Boolean)false);
            }
            case "input": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "tool": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getTool().func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "tooltip_fluid_input": {
                if (this.recipe.getFluidIngredient() != null) {
                    FluidStack fluid = (FluidStack)this.recipe.getFluidIngredient().getRepresentations().get(0);
                    String i18nFluidName = TextHelper.localize(fluid.getTranslationKey(), new Object[0]);
                    return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.fluid", fluid.getAmount(), i18nFluidName));
                }
                return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.no_fluid", new Object[0]));
            }
            case "tooltip_fluid_output": {
                if (this.recipe.getFluidOutput() != FluidStack.EMPTY) {
                    FluidStack fluid = this.recipe.getFluidOutput();
                    String i18nFluidName = TextHelper.localize(fluid.getTranslationKey(), new Object[0]);
                    return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.fluid", fluid.getAmount(), i18nFluidName));
                }
                return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.no_fluid", new Object[0]));
            }
        }
        return null;
    }
}

