/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class BloodAltarRecipeSerializer<RECIPE extends RecipeBloodAltar>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public BloodAltarRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        Ingredient inputIng = Ingredient.func_199802_a((JsonElement)input);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        int minimumTier = JSONUtils.func_151203_m((JsonObject)json, (String)"upgradeLevel");
        int syphon = JSONUtils.func_151203_m((JsonObject)json, (String)"altarSyphon");
        int consumeRate = JSONUtils.func_151203_m((JsonObject)json, (String)"consumptionRate");
        int drainRate = JSONUtils.func_151203_m((JsonObject)json, (String)"drainRate");
        return this.factory.create(recipeId, inputIng, output, minimumTier, syphon, consumeRate, drainRate);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack output = buffer.func_150791_c();
        int minimumTier = buffer.readInt();
        int syphon = buffer.readInt();
        int consumeRate = buffer.readInt();
        int drainRate = buffer.readInt();
        return this.factory.create(recipeId, input, output, minimumTier, syphon, consumeRate, drainRate);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipeBloodAltar)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeBloodAltar> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, ItemStack var3, int var4, int var5, int var6, int var7);
    }
}

