/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.ModFilterKey;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemModFilter
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack filterStack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.modfilter.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        if (filterStack.func_77978_p() == null) {
            return;
        }
        boolean sneaking = Screen.func_231173_s_();
        if (!sneaking) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.extraInfo").func_240699_a_(TextFormatting.BLUE));
        } else {
            boolean isWhitelist;
            int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
            boolean bl = isWhitelist = whitelistState == 0;
            if (isWhitelist) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.whitelist").func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.blacklist").func_240699_a_(TextFormatting.GRAY));
            }
            InventoryFilter inv = new InventoryFilter(filterStack);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                TranslationTextComponent modText = new TranslationTextComponent("tooltip.bloodmagic.filter.from_mod", new Object[]{stack.func_77973_b().getRegistryName().func_110624_b()});
                if (isWhitelist) {
                    int amount = GhostItemHelper.getItemGhostAmount(stack);
                    if (amount > 0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, modText}));
                        continue;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.all", new Object[]{modText}));
                    continue;
                }
                tooltip.add((ITextComponent)modText);
            }
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        String namespace = ghostStack.func_77973_b().getRegistryName().func_110624_b();
        return new ModFilterKey(namespace, amount);
    }
}

