/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.util.DamageSourceBloodMagic;
import wayoftime.bloodmagic.util.helper.IncenseHelper;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

public class ItemSacrificialDagger
extends Item {
    public ItemSacrificialDagger() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sacrificialdagger.desc").func_240699_a_(TextFormatting.GRAY));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_130014_f_().field_72995_K && PlayerSacrificeHelper.sacrificePlayerHealth((PlayerEntity)entityLiving)) {
            IncenseHelper.setHasMaxIncense(stack, (PlayerEntity)entityLiving, false);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return IncenseHelper.getHasMaxIncense(stack) || super.func_77636_d(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        if (this.canUseForSacrifice(stack)) {
            player.func_184598_c(hand);
            return ActionResult.func_226248_a_((Object)stack);
        }
        int lpAdded = (Integer)ConfigManager.COMMON.sacrificialDaggerConversion.get() * 2;
        if (!player.field_71075_bZ.field_75098_d) {
            SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, 2, lpAdded);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return super.func_77659_a(world, player, hand);
            }
            if (evt.shouldDrainHealth) {
                player.field_70172_ad = 0;
                player.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, 0.001f);
                player.func_70606_j(Math.max(player.func_110143_aJ() - 1.998f, 1.0E-4f));
                if (player.func_110143_aJ() <= 0.001f && !world.field_72995_K) {
                    player.field_70172_ad = 0;
                    player.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, 10.0f);
                }
            }
            if (!evt.shouldFillAltar) {
                return super.func_77659_a(world, player, hand);
            }
            lpAdded = evt.lpAdded;
        } else if (player.func_225608_bj_()) {
            lpAdded = Integer.MAX_VALUE;
        }
        double posX = player.func_226277_ct_();
        double posY = player.func_226278_cu_();
        double posZ = player.func_226281_cx_();
        world.func_184148_a(player, posX, posY, posZ, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), 0.0, 0.0, 0.0);
        }
        if (!world.field_72995_K && PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        PlayerSacrificeHelper.findAndFillAltar(world, (LivingEntity)player, lpAdded, false);
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            this.setUseForSacrifice(stack, this.isPlayerPreparedForSacrifice(world, (PlayerEntity)entity));
        }
    }

    public boolean isPlayerPreparedForSacrifice(World world, PlayerEntity player) {
        return !world.field_72995_K && PlayerSacrificeHelper.getPlayerIncense(player) > 0.0;
    }

    public boolean canUseForSacrifice(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return stack.func_77978_p().func_74767_n("sacrifice");
    }

    public void setUseForSacrifice(ItemStack stack, boolean sacrifice) {
        stack = NBTHelper.checkNBT(stack);
        stack.func_77978_p().func_74757_a("sacrifice", sacrifice);
    }
}

