/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.ElementRegistry;
import wayoftime.bloodmagic.client.hud.element.ElementDemonAura;
import wayoftime.bloodmagic.client.hud.element.ElementDivinedInformation;
import wayoftime.bloodmagic.client.hud.element.ElementHolding;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.tile.TileIncenseAltar;
import wayoftime.bloodmagic.util.helper.NumeralHelper;

public class Elements {
    public static void registerElements() {
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "demon_will_aura"), new ElementDemonAura(), new Vector2f(((Double)ConfigManager.CLIENT.demonWillGaugeX.get()).floatValue(), ((Double)ConfigManager.CLIENT.demonWillGaugeY.get()).floatValue()));
        ElementRegistry.registerHandler(BloodMagic.rl("blood_altar"), new ElementDivinedInformation<TileAltar>(2, true, TileAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 46, 16, 16), altar -> altar == null ? "IV" : NumeralHelper.toRoman(altar.getTier())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 16, 46, 16, 16), altar -> String.format("%d/%d", altar == null ? 0 : altar.getCurrentBlood(), altar == null ? 10000 : altar.getCapacity())));
            }
        }, new Vector2f(((Double)ConfigManager.CLIENT.bloodAltarGaugeX.get()).floatValue(), ((Double)ConfigManager.CLIENT.bloodAltarGaugeY.get()).floatValue()));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "blood_altar_adv"), new ElementDivinedInformation<TileAltar>(5, false, TileAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 46, 16, 16), altar -> altar == null ? "IV" : NumeralHelper.toRoman(altar.getTier())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 16, 46, 16, 16), altar -> String.format("%d/%d", altar == null ? 0 : altar.getCurrentBlood(), altar == null ? 10000 : altar.getCapacity())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 32, 46, 16, 16), altar -> {
                    if (altar == null || !altar.isActive()) {
                        return I18n.func_135052_a((String)"hud.bloodmagic.inactive", (Object[])new Object[0]);
                    }
                    int progress = altar.getProgress();
                    int totalLiquidRequired = altar.getLiquidRequired() * altar.func_70301_a(0).func_190916_E();
                    return String.format("%d/%d", progress, totalLiquidRequired);
                }));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 48, 46, 16, 16), altar -> altar == null ? "0" : String.valueOf((int)(altar.getConsumptionRate() * (altar.getConsumptionMultiplier() + 1.0f)))));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 64, 46, 16, 16), altar -> altar == null ? "0" : String.valueOf(altar.getTotalCharge())));
            }
        }, new Vector2f(((Double)ConfigManager.CLIENT.bloodAltarAdvGaugeX.get()).floatValue(), ((Double)ConfigManager.CLIENT.bloodAltarAdvGaugeY.get()).floatValue()));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "incense_altar"), new ElementDivinedInformation<TileIncenseAltar>(2, true, TileIncenseAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileIncenseAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileIncenseAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 80, 46, 16, 16), incense -> incense == null ? "0" : String.valueOf((int)(100.0 * (double)((int)(100.0 * incense.tranquility)) / 100.0))));
                information.accept((Pair<Sprite, Function<TileIncenseAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 96, 46, 16, 16), incense -> incense == null ? "0" : String.valueOf((int)(100.0 * incense.incenseAddition))));
            }
        }, new Vector2f(((Double)ConfigManager.CLIENT.incenseGaugeX.get()).floatValue(), ((Double)ConfigManager.CLIENT.incenseGaugeY.get()).floatValue()));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "holding"), new ElementHolding(), new Vector2f(0.72f, 1.0f));
    }
}

