/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.WoodType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class RegistrationHelper {
    private static final List<WoodType> WOOD_TYPES = new ArrayList<WoodType>();
    private static final List<Supplier<? extends Block>> SIGN_BLOCKS = new ArrayList<Supplier<? extends Block>>();

    public static <T> T injected() {
        return null;
    }

    public static <I extends IForgeRegistryEntry<? super I>> Supplier<I> castDelegate(IRegistryDelegate<? super I> delegate) {
        return () -> (IForgeRegistryEntry)delegate.get();
    }

    public static <T extends IForgeRegistryEntry<T>> void handleMissingMappings(RegistryEvent.MissingMappings<T> event, String modID, Function<String, T> handler) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            IForgeRegistryEntry value;
            if (!modID.equals(mapping.key.func_110624_b()) || (value = (IForgeRegistryEntry)handler.apply(mapping.key.func_110623_a())) == null) continue;
            mapping.remap(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWoodType(WoodType type) {
        List<WoodType> list = WOOD_TYPES;
        synchronized (list) {
            WOOD_TYPES.add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSignBlock(Supplier<? extends Block> sign) {
        List<Supplier<? extends Block>> list = SIGN_BLOCKS;
        synchronized (list) {
            SIGN_BLOCKS.add(sign);
        }
    }

    public static void forEachWoodType(Consumer<WoodType> consumer) {
        WOOD_TYPES.forEach(consumer);
    }

    public static void forEachSignBlock(Consumer<? super Block> consumer) {
        SIGN_BLOCKS.forEach(block -> consumer.accept((Block)block.get()));
    }

    private RegistrationHelper() {
    }
}

