/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpTagCommand;

public class DumpLootModifiers {
    protected static final ResourceLocation GLOBAL_LOOT_MODIFIERS = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
    private static final String LOOT_MODIFIER_PATH = GLOBAL_LOOT_MODIFIERS.func_110624_b() + "/" + GLOBAL_LOOT_MODIFIERS.func_110623_a();
    private static final ITextComponent LOOT_MODIFIER_SUCCESS_LOG = new TranslationTextComponent("command.mantle.dump_loot_modifiers.success_log");
    protected static final SimpleCommandExceptionType ERROR_READING_LOOT_MODIFIERS = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.mantle.dump_loot_modifiers.read_error", new Object[]{GLOBAL_LOOT_MODIFIERS}));

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(1))).then(Commands.func_197057_a((String)"save").executes(source -> DumpLootModifiers.run((CommandContext<CommandSource>)source, true)))).then(Commands.func_197057_a((String)"log").executes(source -> DumpLootModifiers.run((CommandContext<CommandSource>)source, false)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int run(CommandContext<CommandSource> context, boolean saveFile) throws CommandSyntaxException {
        Throwable throwable;
        ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
        IResourceManager manager = ((CommandSource)context.getSource()).func_197028_i().getDataPackRegistries().func_240970_h_();
        try {
            for (Object resource : manager.func_199004_b(GLOBAL_LOOT_MODIFIERS)) {
                try {
                    InputStream input = resource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                        throwable = null;
                        try {
                            JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)DumpTagCommand.GSON, (Reader)reader, JsonObject.class);
                            if (json == null) {
                                Mantle.logger.error("Couldn't load global loot modifiers from {} in data pack {} as it is empty or null", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.func_199026_d());
                                continue;
                            }
                            if (JSONUtils.func_151209_a((JsonObject)json, (String)"replace", (boolean)false)) {
                                finalLocations.clear();
                            }
                            JsonArray entryList = JSONUtils.func_151214_t((JsonObject)json, (String)"entries");
                            for (JsonElement entry : entryList) {
                                ResourceLocation res = ResourceLocation.func_208304_a((String)JSONUtils.func_151206_a((JsonElement)entry, (String)"entry"));
                                if (res == null) continue;
                                finalLocations.remove(res);
                                finalLocations.add(res);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable reader) {
                        throwable2 = reader;
                        throw reader;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable2 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable reader) {
                                throwable2.addSuppressed(reader);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    Mantle.logger.error("Couldn't read global loot modifier list {} in data pack {}", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.func_199026_d(), (Object)ex);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
        }
        catch (IOException ex) {
            throw ERROR_READING_LOOT_MODIFIERS.create();
        }
        JsonArray entries = new JsonArray();
        for (ResourceLocation location : finalLocations) {
            entries.add(location.toString());
        }
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("entries", (JsonElement)entries);
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), LOOT_MODIFIER_PATH);
            Path path = output.toPath();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                throwable = null;
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)json));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save global loot manager to {}", (Object)path, (Object)ex);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.mantle.dump_loot_modifiers.success_save", new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a(LOOT_MODIFIER_SUCCESS_LOG, true);
            Mantle.logger.info("Dump of global loot modifiers:\n{}", (Object)DumpTagCommand.GSON.toJson((JsonElement)json));
        }
        return finalLocations.size();
    }
}

