/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.TagCollectionArgument;

public class DumpAllTagsCommand {
    private static final String TAG_DUMP_PATH = "./mantle_data_dump";
    private static final int EXTENSION_LENGTH = ".json".length();

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(1))).executes(DumpAllTagsCommand::runAll)).then(Commands.func_197056_a((String)"type", (ArgumentType)TagCollectionArgument.collection()).executes(DumpAllTagsCommand::runType));
    }

    protected static File getOutputFile(CommandContext<CommandSource> context) {
        return ((CommandSource)context.getSource()).func_197028_i().func_71209_f(TAG_DUMP_PATH);
    }

    protected static ITextComponent getOutputComponent(File file) {
        return new StringTextComponent(file.getAbsolutePath()).func_240700_a_(style -> style.setUnderlined(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    private static int runAll(CommandContext<CommandSource> context) throws CommandSyntaxException {
        File output = DumpAllTagsCommand.getOutputFile(context);
        int tagsDumped = 0;
        for (TagCollectionArgument.VanillaTagType type : TagCollectionArgument.VanillaTagType.values()) {
            tagsDumped += DumpAllTagsCommand.runForFolder(context, type.getName(), type.getTagFolder(), output);
        }
        for (ResourceLocation type : ForgeTagHandler.getCustomTagTypeNames()) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(type);
            if (registry == null || registry.getTagFolder() == null) continue;
            tagsDumped += DumpAllTagsCommand.runForFolder(context, type, registry.getTagFolder(), output);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.mantle.dump_all_tags.success", new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        return tagsDumped;
    }

    private static int runType(CommandContext<CommandSource> context) throws CommandSyntaxException {
        File output = DumpAllTagsCommand.getOutputFile(context);
        TagCollectionArgument.Result type = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
        int result = DumpAllTagsCommand.runForFolder(context, type.getName(), type.getTagFolder(), output);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.mantle.dump_all_tags.type_success", new Object[]{type.getName(), DumpAllTagsCommand.getOutputComponent(output)}), true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runForFolder(CommandContext<CommandSource> context, ResourceLocation tagType, String tagFolder, File output) throws CommandSyntaxException {
        HashMap foundTags = Maps.newHashMap();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        IResourceManager manager = server.getDataPackRegistries().func_240970_h_();
        String dataPackFolder = "tags/" + tagFolder;
        for (ResourceLocation resourceLocation : manager.func_199003_a(dataPackFolder, fileName -> fileName.endsWith(".json"))) {
            String path = resourceLocation.func_110623_a();
            ResourceLocation tagId = new ResourceLocation(resourceLocation.func_110624_b(), path.substring(dataPackFolder.length() + 1, path.length() - EXTENSION_LENGTH));
            try {
                for (IResource resource : manager.func_199004_b(resourceLocation)) {
                    try {
                        InputStream inputstream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)DumpTagCommand.GSON, (Reader)reader, JsonObject.class);
                                if (json == null) {
                                    Mantle.logger.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)resource.func_199026_d());
                                    continue;
                                }
                                foundTags.computeIfAbsent(resourceLocation, id -> ITag.Builder.func_200047_a()).func_232956_a_(json, resource.func_199026_d());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException ex) {
                        Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)resource.func_199026_d(), (Object)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {}", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)ex);
            }
        }
        for (Map.Entry entry : foundTags.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            Path path = output.toPath().resolve(location.func_110624_b() + "/" + location.func_110623_a());
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)((ITag.Builder)entry.getValue()).func_232965_c_()));
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save tags to {}", (Object)path, (Object)ex);
            }
        }
        return foundTags.size();
    }
}

