/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.AnimationToggleElement;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.StructureElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

@OnlyIn(value=Dist.CLIENT)
public class ContentStructure
extends PageContent {
    public static final transient String ID = "structure";
    public String title;
    public String data;
    public String text;
    public final transient Template template = new Template();
    public transient List<Template.BlockInfo> templateBlocks = new ArrayList<Template.BlockInfo>();

    @Override
    public void load() {
        BookRepository repo = this.parent.source;
        if (this.data == null || this.data.isEmpty()) {
            return;
        }
        ResourceLocation location = repo.getResourceLocation(this.data);
        IResource resource = repo.getResource(location);
        if (resource == null) {
            return;
        }
        try {
            CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a((InputStream)resource.func_199027_b());
            this.template.func_186256_b(compoundnbt);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.templateBlocks = ((Template.Palette)this.template.field_204769_a.get(0)).func_237157_a_();
        for (int i = 0; i < this.templateBlocks.size(); ++i) {
            Template.BlockInfo info = this.templateBlocks.get(i);
            if (info.field_186243_b == Blocks.field_150350_a.func_176223_P()) {
                this.templateBlocks.remove(i);
                --i;
                continue;
            }
            if (!info.field_186243_b.func_196958_f()) continue;
            Mantle.logger.error("Found non-default air block in template " + this.data);
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y = this.getTitleHeight();
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
        }
        int offset = 0;
        int structureSizeX = BookScreen.PAGE_WIDTH;
        int structureSizeY = BookScreen.PAGE_HEIGHT - y - 10;
        if (!StringUtils.func_151246_b((String)this.text)) {
            offset = 15;
            structureSizeX -= 2 * offset;
            structureSizeY -= 2 * offset;
            list.add(new TextElement(0, BookScreen.PAGE_HEIGHT - 10 - 2 * offset, BookScreen.PAGE_WIDTH, 2 * offset, this.text));
        }
        if (this.template != null && this.template.func_186259_a() != BlockPos.field_177992_a) {
            boolean showButtons = this.template.func_186259_a().func_177956_o() > 1;
            StructureElement structureElement = new StructureElement(offset, y, structureSizeX, structureSizeY, this.template, this.templateBlocks);
            list.add(structureElement);
            if (showButtons) {
                int col = book.appearance.structureButtonColor;
                int colHover = book.appearance.structureButtonColorHovered;
                int colToggled = book.appearance.structureButtonColorToggled;
                list.add(new AnimationToggleElement(BookScreen.PAGE_WIDTH - ArrowButton.ArrowType.REFRESH.w, 0, ArrowButton.ArrowType.REFRESH, col, colHover, colToggled, structureElement));
            }
        }
    }
}

