/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.block;

import com.refinedmods.rangedpumps.tile.PumpState;
import com.refinedmods.rangedpumps.tile.PumpTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

public class PumpBlock
extends Block {
    @ObjectHolder(value="rangedpumps:pump")
    public static final PumpBlock BLOCK = null;

    public PumpBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.9f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName("rangedpumps", "pump");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PumpTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof PumpTile) {
            PumpTile pump = (PumpTile)tile;
            IEnergyStorage energy = (IEnergyStorage)pump.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            if (energy == null) {
                return ActionResultType.SUCCESS;
            }
            ITextComponent message = PumpState.getMessage(pump);
            if (message != null) {
                player.func_145747_a(message, player.func_110124_au());
            }
            if (pump.getTank().getFluidAmount() == 0) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.rangedpumps.pump.state_empty", new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}), player.func_110124_au());
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.rangedpumps.pump.state", new Object[]{pump.getTank().getFluidAmount(), pump.getTank().getFluid().getDisplayName(), energy.getEnergyStored(), energy.getMaxEnergyStored()}), player.func_110124_au());
            }
        }
        return ActionResultType.SUCCESS;
    }
}

