/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.ITileNetworkSync;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SortClientMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;

    private SortClientMessage() {
    }

    public SortClientMessage(BlockPos pos, boolean direction, EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public static void handle(SortClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            TileEntity tileEntity = mc.field_71441_e.func_175625_s(message.pos);
            if (tileEntity instanceof ITileNetworkSync) {
                ITileNetworkSync ts = (ITileNetworkSync)tileEntity;
                ts.setDownwards(message.direction);
                ts.setSort(message.sort);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static SortClientMessage decode(PacketBuffer buf) {
        SortClientMessage message = new SortClientMessage();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        message.pos = buf.func_179259_c();
        return message;
    }

    public static void encode(SortClientMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
        if (msg.pos != null) {
            buf.func_179255_a(msg.pos);
        } else {
            buf.func_179255_a(BlockPos.field_177992_a);
        }
    }
}

